// The Cocoa GCCommitDetailsViewController is available as a JavaScript variable:
// window.CocoaController
// logging can be done with: CocoaController.log(CocoaController.displayedCommit.subject());


var constants = {
	gravatarPlaceholderImagePath: '../img/avatarDefaultPlaceholder@2x.png'
};


/**
 Replaces the dummy content in the HTML template with the real content
 */
function fillTemplate(){
	updateLoadingMessageArea(loadingMessage, false);
	$("#data_subject").html(commitSubject);
	$("#data_commitHash").html(commitHash);
	$("#data_author").html(authorName);
	$("#data_author").attr('title', authorEmail);
	$("#data_authorDate").html(authorDate);
	if(authorImage){
		$("#data_authorImage").html(authorImage);
	}else{
		$("#data_authorImage").remove();
	}
	
	// committer (if any)
	if(committerName){
		$("#data_committer").html(committerName);
		$("#data_committer").attr('title', committerEmail);
	}else{
		// remove committer area
		$("#committerActorArea").remove();
	}
	if(committerImage){
		$("#data_committerImage").html(committerImage);
	}else{
		$("#data_committerImage").remove();
	}
	if(committerDate){
		$("#data_committerDate").html(committerDate);
	}else{
		$("#committerDateArea").remove();
	}
	
	// branches & tags (if any)
	if(!commitRefs){
		$("#tagsAndBranchesArea").remove();
	}else{
		// clear dummy content
		$("#data_tagsAndBranches").html("");
		// eval json string
		eval('var commitRefItems = ' + commitRefs);
		var ref = "";
		for(var i=0; i<commitRefItems.length; i++){
			ref = '<span class="refBadge refBadgeType'+ commitRefItems[i].refType +'">' + commitRefItems[i].name + '</span>';
			$("#data_tagsAndBranches").append(ref);
		}
	}
	
	// other hashes (if any)
	if(parentHashes){
		var templateString = $("#parentHashesArea").html();
		// clear dummy content
		$("#parentHashesArea").html("");
		for(var i=0; i<parentHashes.length; i++){
			$("#parentHashesArea").append(templateString);
			$(".data_parentHash:last").html('<a href="javascript:void(0)" onclick="CocoaController.commitHashClicked(\''+parentHashes[i]+'\');">' + parentHashes[i] + '</a>');
		}		
	}else{
		$("#parentHashesArea").remove();
	}
	
	if(treeHash){
		// note: we're using the COMMIT hash as parameter
		$("#data_treeHash").html('<a href="javascript:void(0)" onclick="CocoaController.treeHashClickedForCommit(\''+commitHash+'\');">' + treeHash + '</a>');
	}else{
		$("#treeHashArea").remove();
	}
	
	
	// commit subject + body
	$("#data_commitSubjectLarge").html(commitSubject);
	if(commitBody){
		$("#data_commitBody").html(commitBody);
	}else{
		$("#data_commitBody").remove();
	}
    
    CocoaController.startLoadingChangeset();
}


/**
 Configures the "option gear" menu / popUpButton to have the defined options
 */
function setupOptionsMenu(){
	// options for the contextual menu are passed as JSON string - eval it first
	eval('var optionsMenuOptions = ' + optionsMenuOptionsJson);

	$("#optionsMenuButton").contextMenu('options-menu', 
										optionsMenuOptions,
										{	callback: contextualMenuItemClicked,
											disable_native_context_menu: true, 
											activateOnLeftClick:true,
											align: 'right' }
										);
}


/**
 Adds contextual menus to all relevant items
 */
function setupContextualMenus(){
	$(".changedFilesLine").each(function(index, el){
								// don't allow contextual menu on deleted file
								if($('.deleted',el).length > 0) return;
								
								$(el).contextMenu('context-menu-committed-file', 
												  [ { title: 'Restore File in Working Directory...',
													  cocoaAction: 'restoreFileInWorkingDirectoryMenuItemOptionClicked:'},
                                                    { title: 'Show File History',
                                                      cocoaAction: 'showFileHistoryMenuItemOptionClicked:'}
												   ],
												  { callback: contextualMenuItemClicked,
												  disable_native_context_menu: true, 
												  activateOnLeftClick:false,
												  align: 'left' }
												  );
								});
}


function contextualMenuItemClicked(menuOption, clickedItem){
	if(menuOption.cocoaAction == 'restoreFileInWorkingDirectoryMenuItemOptionClicked:' ||
       menuOption.cocoaAction == 'showFileHistoryMenuItemOptionClicked:'){
		var itemPath = $('a', clickedItem).attr('filePath');
	}else{
		var itemPath = false;
	}
	
	// call cocoa controller
	CocoaController.contextualMenuItemClicked(menuOption.cocoaAction, itemPath);
}


/**
 Update the actor/committer image with a new one that was retrieved from remote
 */
function updateLoadedImage(actorEmailId, imageTag){
	var imageElement = document.getElementById(actorEmailId);	// jQuery doesn't seem to like IDs with characters like .- 
	if(imageElement){
		$(imageElement).replaceWith(imageTag);
	}
}


/**
 Shows the list of changed files (#changeset)
 */
function updateChangesetArea(changesetHtml){
	if(!changesetHtml){
		// no changeset information available
		$("#changeset").remove();
		// set the background to white
		$("body, html").css('background', 'white');
		
	}else{
		$("#changeset").replaceWith(changesetHtml);
		setupContextualMenus();
	}
}


/**
 Shows the diffs for the changed files
 */
function updateDiffArea(diffHtml){
	if(!diffHtml){
		// no diff content available
		$("#diffs").remove();
		// set the background to white
		$("body, html").css('background', 'white');
		
	}else{
		$("#diffs").replaceWith(diffHtml);
	}
}


/**
 Adds CSS rules to the document's head
 */
function insertCss(cssContent){
	$('head').append('<style type="text/css">'+cssContent+'</style>');
}


/**
 Shows the "Large amount of diff data" warning area
 */
function showLargeAmountOfDataWarning(){
	$('#loadingMessageArea').hide();
	$('#largeDiffWarningArea').show();
}


/**
 Continues loading of a large diff
 */
function continueLoadingLargeDiff(){
	$('#largeDiffWarningArea').hide();
	$('#loadingMessageArea').show();
	CocoaController.continueLoadingLargeAmountOfData();	
}

function diffTool(){
	CocoaController.openDiffTool();
}


/**
 Updates the loading message area to either show "Loading..." or "Error..."
 */
function updateLoadingMessageArea(theMessageText, hideLoadingWheel){
	$("#loadingMessage").html(theMessageText);
	if(hideLoadingWheel){
		$("#loaderWheel").hide();
	}else{
		$("#loaderWheel").show();
	}
}


/**
 Triggers the copy diff to clipboard action in the CocoaController
 */
function copyDiffToClipboard(filePath, clickedEl){
	$(clickedEl).addClass("loadingDiffForFile");
	CocoaController.copyDiffToClipboard(filePath);
}

function copyDiffToClipboardDidFinishSuccessfully(){
	$('.titleIcon').removeClass("loadingDiffForFile");
}


/**
 Performs various layout-relevant tasks
 */
function setupPage(){	
	$('#loadLargeDiffButton').mousedown(function(){
										$(this).addClass('pressed');
										});
	$('#loadLargeDiffButton, body').mouseup(function(){
											$('#loadLargeDiffButton').removeClass('pressed');
											});
    $('#diffToolButton').mouseup(function(){
                             diffTool();
											});
	$('#loadLargeDiffButton').click(function(){
									continueLoadingLargeDiff();
									});
}




/**
 As soon as page is loaded, starts to setup content
 */
$(function(){
  //  CocoaController.log("Hello to Cocoa NSLog from JavaScript");  
  setupPage();
  fillTemplate();
  setupOptionsMenu();
  });