/**
 * jQuery.contextMenu - Show a custom context when right clicking something
 * Jonas Arnklint, http://github.com/arnklint/jquery-contextMenu
 * Released into the public domain
 * Date: Jan 14, 2011
 * @author Jonas Arnklint
 * @version 1.3
 *  
 */

/**
 * Extended by Tobias Günther, fournova GmbH
 * April 2011
 *
 */

// Making a local '$' alias of jQuery to support jQuery.noConflict
(function($) {
  jQuery.fn.contextMenu = function ( name, actions, options ) {
      var me = this,
          menu = $('<ul id="'+name+'" class="context-menu"></ul>').hide().appendTo('body'),
          active_element = null, // last clicked element that responds with contextMenu
          hide_menu = function() {
            $('.context-menu').each(function() {
              $(this).trigger("closed");
              $(this).hide();
            });
            $('body').unbind('click', hide_menu);
          }, 
          default_options = {
              disable_native_context_menu: false // disables the native contextmenu everywhere you click
          },
          options = $.extend(default_options, options);
      
      $(document).bind('contextmenu', function(e){
        	if (options.disable_native_context_menu) e.preventDefault();
        	hide_menu();
      });

      $.each(actions, function(index, item) {
          var menuItem;
 		  if(item.cocoaAction || item.jsAction){
			menuItem = $('<li><a href="#">'+item.title+'</a></li>');
	          menuItem.bind('click', function(e) {
				options.callback(item, active_element);
				e.preventDefault();
	          });

		  }else{
			menuItem = $('<li><hr /></li>');
		  }

          if (item.cssClass)
            menuItem.attr("class", item.cssClass);

		  menuItem.appendTo(menu);
      });


      return me.bind(options.activateOnLeftClick ? 'click' : 'contextmenu', function(e){
		  if((!options.activateOnLeftClick && e.which == 3) ||
			  (options.activateOnLeftClick && e.which == 1)){

	          // Hide any existing context menus
	          hide_menu(); 

	          active_element = $(this); // set clicked element
			  active_element.blur();
			  // clear any ugly text selection
			  window.getSelection().empty()

	          if (options.showMenu) {
	              options.showMenu.call(menu, active_element);
	          }

	          // Bind to the closed event if there is a hideMenu handler specified
	          if (options.hideMenu) {
	              menu.bind("closed", function() {
	                  options.hideMenu.call(menu, active_element);
	              });
	          }
			
			  var leftPosition = (options.align == 'right') ? (e.pageX - menu.width()) : e.pageX;
			  var topPosition = e.pageY+8;
	          menu.show(0, function() { $('body').bind('click', hide_menu); }).css({
	            position: 'absolute', 
	            top: topPosition, 
	            left: leftPosition,
	            zIndex: 1000 
	          });
	          return false;
		  }
      });
  }
})(jQuery);