// The Cocoa GCCommitDetailsViewController is available as a JavaScript variable:
// window.CocoaController
// logging can be done with: CocoaController.log(CocoaController.displayedCommit.subject());



/**
 Update the diff area to show the parsed file diffs
 */
function updateDiffArea(diffHtml){
	if(diffHtml){
		// replace with real changeset & diff contents
		$("#loadingMessageArea").hide();
		$("#noDiffAvailable").hide();
		$("#contentContainer").html(diffHtml).show();
	}else{
		$("#loadingMessageArea").hide();
		$("#noDiffAvailable").show();
		$("#contentContainer").hide();
	}
	
	cropLongFilePath();
}


/**
 Updates the loading message area to either show "Loading..." or "Error..."
 */
function updateLoadingMessageArea(theMessageText, hideLoadingWheel){
	$("#loadingMessage").html(theMessageText);
	if(hideLoadingWheel){
		$("#loaderWheel").hide();
	}else{
		$("#loaderWheel").show();
	}
}


/**
 Crops too long file path strings to the maximum visible length
 */
function cropLongFilePath(){
	$(".diff").each(function(index, el){
					el = $(el);
					var contentWidth = $(".title", el).outerWidth();
					var availableWidth = $("body").outerWidth() - ($(".titleIcon", el).outerWidth() + 50);
					
					// is the content/text longer than can be displayed?
					if(contentWidth > availableWidth) {
						$(".titleIcon", el).addClass("croppedTitle");
						$(".titleIcon", el).text("...");
						// re-measure the container's width because the css class just changed the width
						availableWidth = $("body").outerWidth() - ($(".titleIcon", el).outerWidth() + 50);
						$(".titleContainer", el).width(availableWidth);
					}else if(contentWidth > $(".titleContainer", el).outerWidth()){
						$(".titleContainer", el).width(availableWidth);
					}else if($(".titleContainer", el).outerWidth() > contentWidth){
						$(".titleIcon", el).removeClass("croppedTitle");
						$(".titleIcon", el).text("");
						$(".titleContainer", el).width(contentWidth);
					}
	});
}


/**
 Triggers the copy diff to clipboard action in the CocoaController
 */
function copyDiffToClipboard(filePath, clickedEl){
	CocoaController.copyDiffToClipboard(filePath);
}


/**
 Performs various layout-relevant tasks
*/
function setupPage(){
	$(window).resize(function() {
						cropLongFilePath();
					 });
}




/**
 As soon as page is loaded, starts to setup content
 */
$(function(){
//  CocoaController.log("Hello to Cocoa NSLog from JavaScript");  
  setupPage();
});