// The Cocoa GCCommitDetailsViewController is available as a JavaScript variable:
// window.CocoaController
// logging can be done with: CocoaController.log(CocoaController.displayedCommit.subject());

var lastClickedCommitHash;


function showFileContent(contentString){
	$("#loadingMessageArea").hide();
	if(!contentString){
		// no preview available
		$("#contentArea").hide();
		$("#largeContentWarningArea").hide();
		$("#shadowContainer").show();
		$("#nothingToShowArea").show();
	}else{
		// show content
		$("#shadowContainer").hide();
		$("#nothingToShowArea").hide();
		$("#largeContentWarningArea").hide();
		$("#contentArea").show().html(contentString);
        setupMouseOvers();
	}
}


/**
 Shows the "Large amount of data" warning area
 */
function showLargeContentWarning(){
	$('#loadingMessageArea').hide();
	$("#contentArea").hide();
	$("#nothingToShowArea").hide();
	$("#shadowContainer").show();
	$('#largeContentWarningArea').show();
}


/**
 Attach mouseenter/mouseleave event handlers to gutterRows
 */
function setupMouseOvers(){
    // toggle action button
    $('.gutterRow').mouseenter(function(){
                               var groupNumber = $(this).attr('group');
                               $(this).siblings().andSelf().filter('.group_'+groupNumber+'.firstGroupRow').addClass('mouseover');
                               });
    $('.gutterRow').mouseleave(function(){
                               var groupNumber = $(this).attr('group');
                               $(this).siblings().andSelf().filter('.group_'+groupNumber+'.firstGroupRow').removeClass('mouseover');
                               });
}


/*
 Hides the PopOver
 */
function hidePopOver(){
	$('.firstGroupRow').removeClass('activePopOver');
	$('#blameDetailsPopOver').hide();
}


/*
 Show PopOver with commit details for the clicked actionButton/commit
 */
function showPopOverForClickedElement(clickedEl, event){
	$(clickedEl).addClass('activePopOver');
	lastClickedCommitHash = $(clickedEl).attr('commithash');
	var commitSubject = $('.commitSubject', clickedEl).text();
	
	var windowScrollTop = $(window).scrollTop();
	var elTop = $(clickedEl).offset().top;
	var elLeft = $('.actionButton', clickedEl).offset().left;
	
	var windowHeight = $(window).height();
	var popOverHeight = $('#blameDetailsPopOver').height();
	var popOverTop = ((windowScrollTop+windowHeight)-(elTop+popOverHeight-20) < 0) ? elTop-popOverHeight+27 : elTop-5;
	
	$('#blameDetailsContentBar').text(commitSubject);
	$('#commitSha').text('SHA '+ lastClickedCommitHash.substr(0, 10));
	$('#blameDetailsPopOver').css({'top':popOverTop+'px', 'left':(elLeft-20)+'px'}).show();
}




/**
 As soon as page is loaded, starts to setup content
 */
$(function(){
  //  CocoaController.log("Hello to Cocoa NSLog from JavaScript");  
  $('#loadLargeContentButton').mousedown(function(){
                                         $(this).addClass('pressed');
                                         });
  $('#loadLargeContentButton, body').mouseup(function(){
                                             $('#loadLargeContentButton').removeClass('pressed');
                                             });
  $('#loadLargeContentButton').click(function(){
                                     CocoaController.replaceContent();
                                     });
  $('.firstGroupRow').live('click', function(event){
                            hidePopOver();
                            showPopOverForClickedElement($(this), event);
                           });
  $('#showCommitButton').click(function(){
                               CocoaController.openCommitWithHash(lastClickedCommitHash);
                               });
  $('#showTreeButton').click(function(){
                             CocoaController.showTreeForCommitWithHash(lastClickedCommitHash);
                             });
  $('body').mouseup(function(){
                    hidePopOver();
                    });
  });