// The Cocoa GCCommitDetailsViewController is available as a JavaScript variable:
// window.CocoaController
// logging can be done with: CocoaController.log(CocoaController.displayedCommit.subject());

var selectedLines = {};

var isStagingEnabled = false;
var isUnstagingEnabled = false;
var isDiscardingEnabled = false;

var constants = {
contextModeChunk: 1,
contextModeSingleLine: 2,
actionButtonsWidth: 229,
actionButtonsMarginRight: 10,
processChangesByStaging: 1,
processChangesByUnstaging: 2,
processChangesByDiscarding: 3
};



/*******
 *  Display content
 */
function showFileContent(contentString){
	if(loadingOverlaysPresent()){
		insertLoadedContentAfterRemovingLoadingOverlays(contentString);
	}else{
		insertLoadedContent(contentString);
	}
}


function insertLoadedContent(contentString){
	$("#loadingMessageArea").hide();
	$("#largeContentWarningArea").hide();
	$("#contentArea").show().html(contentString);
	adjustStickySectionHeaders();
	addActionButtonsToChunkHeaders();
}


function insertLoadedContentAfterRemovingLoadingOverlays(contentString){
	var chunksToRemove = $('.chunkLoadingOverlay.completeChunk');
	var chunksToRemoveAmount = chunksToRemove.length;
	var counter = 0;
	chunksToRemove.each(function(index, el){
						counter += 1;
						var chunkIndex = $(el).attr('chunkindex');
						$('#chunk_'+chunkIndex).animate(
														{ height:'0px' }, 
														500, 
														function(){
														$('#chunk_'+chunkIndex).remove();
														if(counter == chunksToRemoveAmount){
														insertLoadedContent(contentString);
														}
														}
														);
						});
}


function insertCss(cssContent){
	$('head').append('<style type="text/css">'+cssContent+'</style>');
}


/**
 Shows the "Large amount of data" warning area
 */
function showLargeContentWarning(){
	$("#loadingMessageArea").hide();
	$("#contentArea").hide();
	$("#largeContentWarningArea").show();
}


/*******
 *  Stage / unstage / discard
 */
function processChanges(mode, chunkIndex){
	if(selectedLines[chunkIndex] && selectedLines[chunkIndex].length > 0){
		var lines = selectedLines[chunkIndex];
	}else{
		var lines = new Array();
	}
	
	addLoadingOverlayForChunk(chunkIndex, lines);
	CocoaController.processChangesForChunk(mode, chunkIndex, lines);
}


/*******
 *  Loading overlays after staging/unstaging/discarding
 */
function addLoadingOverlayForChunk(chunkIndex, lines){
	var chunkEl = $('#chunk_'+chunkIndex);
	var top = chunkEl.position().top;
	var left = chunkEl.position().left;
	var width = chunkEl.innerWidth();
	var height = chunkEl.innerHeight();
	var completeChunk = (lines.length == 0) ? 'completeChunk' : 'lineWise';
	
	var overlayHtml = '';
	overlayHtml += '<div class="chunkLoadingOverlay '+completeChunk+'" chunkindex="'+chunkIndex+'" style="top:0px; left:'+left+'px; width:'+width+'px; height:100%">';
	overlayHtml +=		'<img class="chunkLoaderWheel" src="../img/chunkStaging/activityIndicator.gif" style="left:'+ ((($(window).width() - 32) /2) + $(window).scrollLeft())+'px; top:'+((height -32)/2)+'px" />';
	overlayHtml += '</div>'
	
	$('#chunk_'+chunkIndex).append(overlayHtml);
}


function removeAllLoadingOverlays(){
	$('.chunkLoadingOverlay').remove();
}


function loadingOverlaysPresent(){
	// only overlays for complete chunks (not linewise) are considered
	var counter = $('.chunkLoadingOverlay.completeChunk').length;
	return (counter > 0);
}


/*******
 * Add action buttons to each chunk header, depending on which actions (stage, unstage, discard) are possible
 */
function addActionButtonsToChunkHeaders(){
	var buttonsHtml = "";
	var chunkButtonHtml = "";
	var linesButtonHtml = "";
	if(isDiscardingEnabled){
		chunkButtonHtml += '<div class="discardChunkButton"></div>';
		linesButtonHtml += '<div class="discardLinesButton"></div>';
	}
	if(isStagingEnabled){
		chunkButtonHtml += '<div class="stageChunkButton"></div>';
		linesButtonHtml += '<div class="stageLinesButton"></div>';
	}
	if(isUnstagingEnabled){
		chunkButtonHtml += '<div class="unstageChunkButton"></div>';
		linesButtonHtml += '<div class="unstageLinesButton"></div>';
	}
	
	buttonsHtml += '<div class="actionButtonsWrapper"><div class="actionButtonsContainer">';
	buttonsHtml +=  '<div class="actionButtonsChunk inactive">'+chunkButtonHtml+'</div>';
	buttonsHtml +=  '<div class="actionButtonsLines inactive">'+linesButtonHtml+'</div>';
	buttonsHtml += '</div></div>';
	// add buttons to every chunk header
	$('.chunkHeader .codeColumn').each(function(index, el){
									   if($(el).find('.actionButtonsWrapper').length > 0) return;  // don't add if already present
									   $(el).prepend(buttonsHtml);
									   });
	
	repositionActionButtonsToRightBorder();
}


function repositionActionButtonsToRightBorder(){
	var positionX = $('#contentTable').width() - $(window).width() - $(window).scrollLeft() + constants.actionButtonsMarginRight;
	$('.actionButtonsWrapper').css('right', positionX+'px');
}


/********
 * Change selection status for a clicked line / line ranges
 */
function lineWasClicked(event, line){
    if(!isStagingEnabled && !isUnstagingEnabled && !isDiscardingEnabled) return;
    
	// line & event status
	var isLineSelected = line.hasClass('selected');
	var shiftKey = event.shiftKey;
	var cmdKey = event.metaKey;
	
	// actions object
	var chunkIndex = line.closest('.chunk').attr('chunkindex');
	var lineIndex = parseInt(line.attr('lineindex'));
	
	// ===== decide how to change the selection
	if(!isLineSelected && !shiftKey && !cmdKey){
		// add line to selection & deselect all other lines
		deselectAllLines(chunkIndex);
		selectLine(chunkIndex, lineIndex);
	}else if(!isLineSelected && shiftKey){
		// add line to selection & all lines between it and the last selected line
		selectLineRange(chunkIndex, lineIndex, lastSelectedLineIndex(chunkIndex));
	}else if(!isLineSelected && cmdKey){
		// add line to selection
		selectLine(chunkIndex, lineIndex);
	}else if(isLineSelected && !shiftKey && !cmdKey){
		return;
	}else if(isLineSelected && shiftKey){
		// deselect line & all lines between it and the last selected line
		deselectLineRange(chunkIndex, lineIndex, lastSelectedLineIndex(chunkIndex));
	}else if(isLineSelected && cmdKey){
		// deselect line
		deselectLine(chunkIndex, lineIndex);
	}
	
	// ===== check if we're in single line OR in chunk mode
	if(!selectedLines[chunkIndex] || selectedLines[chunkIndex].length == 0){
		changeContextModeForChunk(chunkIndex, constants.contextModeChunk);
	}else{
		changeContextModeForChunk(chunkIndex, constants.contextModeSingleLine);
	}
}


/*********
 *  Line Selection / Deselection
 */
function selectLine(chunkIndex, lineIndex){
	// check if the line is already selected
	if(selectedLines[chunkIndex] && selectedLines[chunkIndex].length > 0){
		for(var i=0; i<selectedLines[chunkIndex].length; i++){
			if(selectedLines[chunkIndex][i] == lineIndex) return;
		}
	}
	// clear any ugly text selection
	window.getSelection().empty()
	
	// check if this is the first selected line
	if(!selectedLines[chunkIndex] || selectedLines[chunkIndex].length == 0){
		selectedLines[chunkIndex] = [];
	}
	
	var concernedLine = $('#chunk_'+chunkIndex+' .line'+lineIndex);
	// the line must be a changed line to be able to select it
	if(concernedLine.hasClass('plusLine') || concernedLine.hasClass('minusLine')){
		// add line to selected line array
		selectedLines[chunkIndex].push(lineIndex);
		// select the line visually
		concernedLine.addClass('selected');
	}
}


function selectLineRange(chunkIndex, startLineIndex, endLineIndex){
	var start = (endLineIndex > startLineIndex) ? startLineIndex : endLineIndex;
	var end = (endLineIndex > startLineIndex) ? endLineIndex : startLineIndex;
	
	for(var i=start; i<=end; i++){
		selectLine(chunkIndex, i);
	}
}


function deselectLine(chunkIndex, lineIndex){
	if(!selectedLines[chunkIndex] || selectedLines[chunkIndex].length == 0) return;
	// clear any ugly text selection
	window.getSelection().empty();
	
	// remove line from selected lines array
	for(var i=0; i<selectedLines[chunkIndex].length; i++){
		if(selectedLines[chunkIndex][i] == lineIndex){
			selectedLines[chunkIndex].splice(i,1);
			// deselect the line visually
			$('#chunk_'+chunkIndex+' .line'+lineIndex).removeClass('selected');
			break;
		}
	}
}


function deselectLineRange(chunkIndex, startLineIndex, endLineIndex){
	var start = (endLineIndex > startLineIndex) ? startLineIndex : endLineIndex;
	var end = (endLineIndex > startLineIndex) ? endLineIndex : startLineIndex;
	for(var i=start; i<=end; i++){
		deselectLine(chunkIndex, i);
	}
}


function deselectAllLines(chunkIndex){
	if(!selectedLines[chunkIndex] || selectedLines[chunkIndex].length == 0) return;
	
	// copy array temporarily (because we're removing items while iterating over it)
	var tmpArray = new Array().concat(selectedLines[chunkIndex]);
	for(var i=0; i<tmpArray.length; i++){
		deselectLine(chunkIndex, tmpArray[i]);
	}
}


function lastSelectedLineIndex(chunkIndex){
	if(!selectedLines[chunkIndex] || selectedLines[chunkIndex].length == 0){
		return false;
	}else{
		return selectedLines[chunkIndex][(selectedLines[chunkIndex].length-1)];
	}
}


function changeContextModeForChunk(chunkIndex, newMode){
	var topPosition = (newMode == constants.contextModeSingleLine) ? '-17px' : '0px';
	$('#chunk_'+chunkIndex+' .actionButtonsContainer').animate({top:topPosition}, 200);
}


/*********
 *  Sticky Section Headers
 *  Based on: Florian Plank (http://www.polarblau.com/ & http://plugins.jquery.com/project/stickySectionHeaders)
 */
function adjustStickySectionHeaders(){
	$('.chunk').each(function(index) {
					 var windowScrollTop = $(window).scrollTop();
					 var chunkTop = $(this).position().top - windowScrollTop;
					 var chunkHeight = $(this).outerHeight();
					 var header = $(this).find('.chunkHeader');
					 var headerHeight = header.outerHeight();
					 
					 if (chunkTop < 0) {
						$(this).addClass('sticky').css('paddingTop', headerHeight);
						if(chunkHeight + chunkTop < headerHeight){
							var headerTop = chunkHeight-headerHeight;
						}else{
							var headerTop = chunkTop*-1
						}
						header.css({ 'top': headerTop });
					 }else{
						$(this).removeClass('sticky').css('paddingTop', '');
					 }
	});
}








/**
 As soon as page is loaded, starts to setup content
 */
$(function(){

  $(window).scroll(function(){
					   // sticky chunk headers
					   adjustStickySectionHeaders();
					   // adjust action buttons' position to right border on scroll
					   repositionActionButtonsToRightBorder();
				   });
  
  // toggle action buttons (stage/unstage/discard)
  $('.chunk').live('mouseenter', function(){
						$(this).removeClass('inactive').addClass('active').addClass('highlightedChunk');
				   });
  $('.chunk').live('mouseleave', function(){
						$(this).removeClass('active').addClass('inactive').removeClass('highlightedChunk');
				   });
  
  
  // selecting changed lines
  $('.chunk').live('click', function(event){
					   // if it's a changed line, we handle the click
					   var changedLine = $(event.target).closest('.lineContent.plusLine, .lineContent.minusLine');
					   if(changedLine.length == 1){
							lineWasClicked(event, $(changedLine[0]));
					   }
				   });
  
  // stage/unstage/discard buttons
  $('.stageChunkButton, .stageLinesButton').live('click', function(){
													var chunkIndex = $(this).closest('.chunk').attr('chunkindex');
													processChanges(constants.processChangesByStaging, chunkIndex);
												 });
  $('.unstageChunkButton, .unstageLinesButton').live('click', function(){
													 var chunkIndex = $(this).closest('.chunk').attr('chunkindex');
													 processChanges(constants.processChangesByUnstaging, chunkIndex);
												 });
  $('.discardChunkButton, .discardLinesButton').live('click', function(){
													 var chunkIndex = $(this).closest('.chunk').attr('chunkindex');
													 processChanges(constants.processChangesByDiscarding, chunkIndex);
												 });
  $('.stageChunkButton, .stageLinesButton, .unstageChunkButton, .unstageLinesButton, .discardChunkButton, .discardLinesButton').live('mousedown', function(){
													$(this).addClass('mousedown');
												});  
  $('body').mouseup(function(){
					$('.stageChunkButton.mousedown, .stageLinesButton.mousedown, .unstageChunkButton.mousedown, .unstageLinesButton.mousedown, .discardChunkButton.mousedown, .discardLinesButton.mousedown').each(function(index, el){
												   // when pushing the mousebutton, then dragging it away from the button (to avoid a click),
												   // some text might get selected (which we must avoid in this case)
												   window.getSelection().empty();
												   // make sure the button loses its pressed status
												   $(el).removeClass('mousedown');
											   });
					}); 
  
  $('#loadLargeContentButton').mousedown(function(){
										 $(this).addClass('pressed');
										 });
  $('#loadLargeContentButton, body').mouseup(function(){
											 $('#loadLargeContentButton').removeClass('pressed');
											 });
  $('#loadLargeContentButton').click(function(){
									 CocoaController.replaceContent();
									 });  
  });