// The Cocoa GCCommitDetailsViewController is available as a JavaScript variable:
// window.CocoaController
// logging can be done with: CocoaController.log(CocoaController.displayedCommit.subject());

/*******
 *  Display content
 */
function showFileContent(contentString){
	insertLoadedContent(contentString);
}


function insertLoadedContent(contentString){
	$("#loadingMessageArea").hide();
	$("#contentArea").show().html(contentString);
	adjustStickySectionHeaders();
	addActionButtonsToChunkHeaders();
}


function insertCss(cssContent){
	$('head').append('<style type="text/css">'+cssContent+'</style>');
}


/*********
 *  Sticky Section Headers
 *  Based on: Florian Plank (http://www.polarblau.com/ & http://plugins.jquery.com/project/stickySectionHeaders)
 */
function adjustStickySectionHeaders(){
	$('.chunk').each(function(index) {
					 var windowScrollTop = $(window).scrollTop();
					 var chunkTop = $(this).position().top - windowScrollTop;
					 var chunkHeight = $(this).outerHeight();
					 var header = $(this).find('.chunkHeader');
					 var headerHeight = header.outerHeight();
					 
					 if (chunkTop < 0) {
						$(this).addClass('sticky').css('paddingTop', headerHeight);
						if(chunkHeight + chunkTop < headerHeight){
							var headerTop = chunkHeight-headerHeight;
						}else{
							var headerTop = chunkTop*-1
						}
						header.css({ 'top': headerTop });
					 }else{
						$(this).removeClass('sticky').css('paddingTop', '');
					 }
	});
}








/**
 As soon as page is loaded, starts to setup content
 */
$(function(){

  $(window).scroll(function(){
					   // sticky chunk headers
					   adjustStickySectionHeaders();
				   });
  
});