//
//  FNFoundationDefines.h
//  FNFoundation
//
//  Created by Florian Bürger on 7/2/12.
//  Copyright (c) 2012 fournova GmbH. All rights reserved.
//

#import <Foundation/Foundation.h>

#ifndef MINUTES
#define MINUTES 60.0
#endif

#ifndef HOURS
#define HOURS 60.0 * MINUTES
#endif

#ifndef DAYS
#define DAYS 24.0 * HOURS
#endif

#ifndef WEEKS
#define WEEKS 7.0 * DAYS
#endif

#define FNNotImplementedYet() [NSException raise:@"FNNotImplementedException" format:@"Not implemented yet."];
#define FNMainThreadAssert() NSAssert([NSThread isMainThread], @"Method is expected to be performed on main thread.");
#define FNAbstractMethodAssert(methodName) NSAssert(0, @"Abstract method '%@' needs to be overridden by subclasses.", methodName);
