//
//  FNOption.h
//  OptionParser
//
//  Created by Heiko Witte on 13.12.16.
//  Copyright © 2016 fournova Software GmbH. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "FNOptionType.h"

@interface FNOption : NSObject <NSCopying>
@property (nonatomic, nullable) NSString *flag;
@property (nonatomic, nullable) NSString *alias;
@property (nonatomic, nonnull) NSString *explanation;
@property (nonatomic, nonnull) NSString *valueDescription;
@property (nonatomic) FNOptionType type;
@property (nonatomic, getter=isRequired) BOOL required;
@property (nonatomic, getter=isHidden) BOOL hidden;
@property (nonatomic, readonly) BOOL hasListValue;

+ (nullable instancetype)optionWithFlag:(nullable NSString *)flag alias:(nullable NSString *)alias explanation:(nonnull NSString *)explanation valueDescription:(nullable NSString *)valueDescription type:(FNOptionType)type required:(BOOL)required;
- (nullable id)initWithFlag:(nullable NSString *)flag alias:(nullable NSString *)alias explanation:(nonnull NSString *)explanation valueDescription:(nullable NSString *)valueDescription type:(FNOptionType)type required:(BOOL)required;
@end
