//
//  FNOptionCommand.h
//  FNFoundation
//
//  Created by Heiko Witte on 01.03.17.
//  Copyright © 2017 Fournova GmbH. All rights reserved.
//

#import <Foundation/Foundation.h>

@class FNOption;
@interface FNOptionCommand : NSObject <NSCopying>
@property (nonatomic, copy, nonnull) NSString *name;
@property (nonatomic, nonnull) NSArray<FNOption *> *options;
@property (nonatomic, copy, nonnull) NSString *explanation;
@property (nonatomic, readonly, nullable) NSArray<NSString *> *argumentNames;
@property (nonatomic, nullable) NSArray<FNOptionCommand *> *subCommands;
@property (nonatomic, getter=isHidden) BOOL hidden;

+ (nullable instancetype)optionCommandWithName:(nonnull NSString *)name options:(nullable NSArray<FNOption *> *)options argumentNames:(nullable NSArray<NSString *> *)argumentNames subCommands:(nullable NSArray<FNOptionCommand *> *)subCommands explanation:(nonnull NSString *)explanation;
- (nullable id)initWithName:(nonnull NSString *)name options:(nullable NSArray<FNOption *> *)options argumentNames:(nullable NSArray<NSString *> *)argumentNames subCommands:(nullable NSArray<FNOptionCommand *> *)subCommands explanation:(nonnull NSString *)explanation;
@end
