//
//  FNRESTAPILinkHeaderParser.h
//  FNFoundation
//
//  Created by Alexander Rinass on 27/05/15.
//  Copyright (c) 2015 Fournova GmbH. All rights reserved.
//

#import <Foundation/Foundation.h>

@interface FNRESTAPILinkHeaderParser : NSObject
@property (nonatomic, readonly) NSDictionary *headerFields;
@property (nonatomic, readonly) NSString *pageParameterName;
@property (nonatomic, readonly) NSString *perPageParameterName;
@property (nonatomic, readonly) NSUInteger nextPageNumber;
@property (nonatomic, readonly) NSUInteger prevPageNumber;
@property (nonatomic, readonly) NSUInteger numberOfTotalPages;
@property (nonatomic, readonly) NSUInteger numberOfItemsPerPage;

+ (instancetype)parserWithHeaderFields:(NSDictionary *)headerFields pageParameterName:(NSString *)pageParameterName perPageParameterName:(NSString *)perPageParameterName;
- (instancetype)initWithHeaderFields:(NSDictionary *)headerFields pageParameterName:(NSString *)pageParameterName perPageParameterName:(NSString *)perPageParameterName;

@end
