//
//  FNTreeManager.h
//  FNFoundation
//
//  Created by Alexander Rinass on 15/04/16.
//  Copyright © 2016 fournova Software GmbH. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "FNTreeManagerDelegate.h"

@class FNTreeNode;
@class FNTreeChangeset;
@interface FNTreeManager : NSObject
@property (nonatomic, weak) id<FNTreeManagerDelegate> delegate;
@property (nonatomic, readonly) NSArray<FNTreeNode *> *rootNodes;
@property (nonatomic, getter=isInitialLoad) BOOL initialLoad;

+ (FNTreeNode *)updateTree:(FNTreeNode *)oldRootNode withTree:(FNTreeNode *)newRootNode;
+ (FNTreeNode *)updateTree:(FNTreeNode *)oldRootNode withTree:(FNTreeNode *)newRootNode updateHandler:(void (^)(FNTreeNode * oldNode, FNTreeNode * newNode))updateHandler;

+ (NSArray<FNTreeNode *> *)updateNodeList:(NSArray<FNTreeNode *> *)oldNodeList withNodeList:(NSArray<FNTreeNode *> *)newNodeList;
+ (NSArray<FNTreeNode *> *)updateNodeList:(NSArray<FNTreeNode *> *)oldNodeList withNodeList:(NSArray<FNTreeNode *> *)newNodeList updateHandler:(void (^)(FNTreeNode * oldNode, FNTreeNode * newNode))updateHandler;

+ (instancetype)treeManagerWithRootNodes:(NSArray<FNTreeNode *> *)rootNodes;

- (void)updateWithRootNodes:(NSArray<FNTreeNode *> *)newRootNodes;
- (void)updateWithRootNodes:(NSArray<FNTreeNode *> *)newRootNodes updateHandler:(void (^)(FNTreeNode * oldNode, FNTreeNode * newNode))updateHandler;
- (void)updateParentNode:(FNTreeNode *)parentItem withChildNodes:(NSArray<FNTreeNode *> *)childItems updateHandler:(void (^)(FNTreeNode * oldNode, FNTreeNode * newNode))updateHandler;

@end
