//
//  FNTreeManagerDelegate.h
//  TreeDiffUnique
//
//  Created by Heiko Witte on 17.03.16.
//  Copyright © 2016 fournova Software GmbH. All rights reserved.
//

#ifndef FNTreeManagerDelegate_h
#define FNTreeManagerDelegate_h

@class FNTreeNode;
@protocol FNTreeManagerDelegate <NSObject>
@optional
- (void)treeManagerWillInsertItemsAtIndexPaths:(NSIndexSet *)indexPaths inParent:(FNTreeNode *)parent;
- (void)treeManagerDidInsertItemsAtIndexPaths:(NSIndexSet *)indexPaths inParent:(FNTreeNode *)parent;
- (void)treeManagerWillDeleteItemsAtIndexPaths:(NSIndexSet *)indexPaths inParent:(FNTreeNode *)parent;
- (void)treeManagerDidDeleteItemsAtIndexPaths:(NSIndexSet *)indexPaths inParent:(FNTreeNode *)parent;
- (void)treeManagerWillMoveItemAtIndex:(NSUInteger)index inParent:(FNTreeNode *)parent toIndex:(NSUInteger)newIndex inParent:(FNTreeNode *)newParent;
- (void)treeManagerDidMoveItemAtIndex:(NSUInteger)index inParent:(FNTreeNode *)parent toIndex:(NSUInteger)newIndex inParent:(FNTreeNode *)newParent;
@end

#endif /* FNTreeManagerDelegate_h */
