//
//  FNGitFormatPatchCommand.h
//  FNGit
//
//  Created by Alexander Rinass on 19/08/14.
//  Copyright (c) 2014 Fournova GmbH. All rights reserved.
//

#import <FNGit/FNGit.h>

@interface FNGitFormatPatchCommand : FNGitCommand
@property (nonatomic) NSString *revision;
@property (nonatomic) NSURL *destinationURL;
@property (nonatomic) NSUInteger startingNumber;
@property (nonatomic) BOOL numbersPatches;
@property (nonatomic) BOOL noPrefix;
@property (nonatomic) NSUInteger limit;
@property (nonatomic, readonly) NSArray *createdPatchFilePaths;

+ (instancetype)gitFormatPatchCommandWithRepository:(FNGitRepository *)repository revision:(NSString *)revision options:(NSDictionary *)options;
- (instancetype)initWithRepository:(FNGitRepository *)repository revision:(NSString *)revision options:(NSDictionary *)options;

@end
