//
//  FNGitSubmoduleHelper.h
//  FNGit
//
//  Created by Alexander Rinass on 12.08.13.
//  Copyright (c) 2013 Fournova GmbH. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "FNGitSubmoduleStatus.h"

@class FNGitRepository;
@class FNGitSubmodule;
@interface FNGitSubmoduleHelper : NSObject

+ (NSString *)absoluteWorkingDirectoryPathForSubmodulePath:(NSString *)submodulePath inRepository:(FNGitRepository *)repository;
+ (NSString *)absoluteGitDirectoryPathForSubmoduleName:(NSString *)submoduleName inRepository:(FNGitRepository *)repository;

+ (NSString *)absoluteWorkingDirectoryPathForSubmodule:(FNGitSubmodule *)submodule inRepository:(FNGitRepository *)repository;
+ (NSString *)absoluteGitDirectoryPathForSubmodule:(FNGitSubmodule *)submodule inRepository:(FNGitRepository *)repository;

+ (NSString *)relativeGitDirectoryPathForSubmoduleWithName:(NSString *)submoduleName path:(NSString *)submodulePath;
+ (NSString *)relativeWorkingTreePathForSubmoduleWithName:(NSString *)submoduleName path:(NSString *)submodulePath;

+ (NSString *)stringRepresentationForSubmoduleStatus:(FNGitSubmoduleStatus)submoduleStatus;

@end
