//
//  GitHubAuth.h
//  Tower
//
//  Created by Alexander Rinass on 12.04.12.
//  Copyright (c) 2012 Fournova GmbH. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <FNFoundation/FNFoundation.h>

typedef NS_ENUM(NSInteger, GitHubAPIAuthenticationType) {
    GitHubAPIAuthenticationTypeBasicAuth,
    GitHubAPIAuthenticationTypeAccessToken
};

@interface GitHubAPICredentials : NSObject <NSCopying>
@property (nonatomic) GitHubAPIAuthenticationType authenticationType;
@property (nonatomic) NSString *host;
@property (nonatomic) NSString *username;
@property (nonatomic) NSString *password;
@property (nonatomic) NSString *accessToken;
@property (nonatomic) NSString *OTP;
@property (nonatomic) BOOL trustsServer;
@property (nonatomic) NSData *serverTrustExceptionCookie;

+ (instancetype)accessTokenCredentialsWithHost:(NSString *)host username:(NSString *)username accessToken:(NSString *)accessToken;
+ (instancetype)basicAuthCredentialsWithHost:(NSString *)host username:(NSString *)username password:(NSString *)password;

@end
