//
//  GitHubFetchOrganizationAPIRequestOperation.h
//  GitHubAPI
//
//  Created by Alexander Rinass on 19.06.12.
//  Copyright (c) 2012 Fournova GmbH. All rights reserved.
//

#import "GitHubAPIRequestOperation.h"

@class GitHubAPIAccount;
@interface GitHubAPIFetchOrganizationRequestOperation : GitHubAPIRequestOperation
@property (nonatomic, readonly) NSString *organizationName;
@property (nonatomic, readonly) GitHubAPIAccount *organization;

+ (instancetype)requestWithCredentials:(GitHubAPICredentials *)credentials organizationName:(NSString *)organizationName;
- (instancetype)initWithCredentials:(GitHubAPICredentials *)credentials organizationName:(NSString *)organizationName;

@end
