//
//  GitHubRepository.h
//  Tower
//
//  Created by Alexander Rinass on 12.04.12.
//  Copyright (c) 2012 Fournova GmbH. All rights reserved.
//

#import <FNFoundation/FNFoundation.h>

@class GitHubAPIAccount;
@interface GitHubAPIRepository : FNRESTAPIModel
@property (nonatomic, readonly) NSInteger repositoryID;
@property (nonatomic) NSString *name;
@property (nonatomic, readonly) NSString *fullName;
@property (nonatomic) NSString *userDescription;
@property (nonatomic) NSURL *homepageURL;
@property (nonatomic, getter = isPrivate) BOOL private;
@property (nonatomic) BOOL hasIssues;
@property (nonatomic) BOOL hasWiki;
@property (nonatomic) BOOL hasDownloads;
@property (nonatomic, readonly) NSString *language;
@property (nonatomic, readonly) NSString *masterBranch;
@property (nonatomic, readonly) NSURL *apiURL;
@property (nonatomic, readonly) NSURL *htmlURL;
@property (nonatomic, readonly) NSURL *cloneURL;
@property (nonatomic, readonly) NSString *sshURL;
@property (nonatomic, readonly) NSURL *svnURL;
@property (nonatomic, readonly) NSURL *mirrorURL;
@property (nonatomic, readonly, getter = isForked) BOOL forked;
@property (nonatomic, readonly) NSInteger forks;
@property (nonatomic, readonly) NSInteger watchers;
@property (nonatomic, readonly) NSInteger openIssues;
@property (nonatomic, readonly) NSInteger size;
@property (nonatomic, readonly) NSDate *pushedDate;
@property (nonatomic, readonly) NSDate *creationDate;
@property (nonatomic, readonly) NSDate *updatedDate;
@property (nonatomic, readonly) GitHubAPIAccount *owner;
@property (nonatomic, readonly) GitHubAPIAccount *organization;
@property (nonatomic, readonly) GitHubAPIRepository *parent;
@property (nonatomic, readonly) GitHubAPIRepository *source;

+ (instancetype)repositoryWithJSONObject:(NSDictionary *)JSONObject;

- (BOOL)isEqualToGitHubAPIRepository:(GitHubAPIRepository *)object;

@end
