//
//  BitbucketUser.h
//  BitbucketAPI
//
//  Created by Patrick Dinger on 12.02.13.
//  Copyright (c) 2013 Fournova GmbH. All rights reserved.
//

#import <FNFoundation/FNFoundation.h>

extern NSString *const BitbucketAPIUserTypeUser;
extern NSString *const BitbucketAPIUserTypeTeam;

@interface BitbucketAPIUser : FNRESTAPIModel
@property (nonatomic, readonly) NSString *userID;
@property (nonatomic, readonly) NSString *username;
@property (nonatomic, readonly) NSString *displayName;
@property (nonatomic, readonly) NSString *type;
@property (nonatomic, readonly) NSString *location;
@property (nonatomic, readonly) NSURL *avatarURL;
@property (nonatomic, readonly) NSURL *htmlURL;
@property (nonatomic, readonly) NSURL *websiteURL;
@property (nonatomic, readonly) NSDate *creationDate;

+ (instancetype)userWithJSONObject:(NSDictionary *)JSONObject;

- (BOOL)isEqualToBitbucketAPIUser:(BitbucketAPIUser *)object;

@end
