//
//  FNErrorDefinition.h
//  FNFoundation
//
//  Created by Alexander Rinass on 29/04/14.
//  Copyright (c) 2014 Fournova GmbH. All rights reserved.
//

#import <Foundation/Foundation.h>

@interface FNErrorDefinition : NSObject
@property (nonatomic, readonly) NSDictionary *definition;
@property (nonatomic, readonly) NSInteger code;
@property (nonatomic, readonly) NSString *name;
@property (nonatomic, readonly) NSString *descriptionFormat;
@property (nonatomic, readonly) NSString *failureReasonFormat;
@property (nonatomic, readonly) NSArray *descriptionKeys;
@property (nonatomic, readonly) NSArray *failureReasonKeys;

+ (instancetype)errorDefinitionWithDefinition:(NSDictionary *)errorDefinition;
- (instancetype)initWithErrorDefinition:(NSDictionary *)errorDefinition;

- (NSString *)localizedDescription:(NSDictionary *)userInfo;
- (NSString *)localizedFailureReason:(NSDictionary *)userInfo;

@end
