//
//  FNOptionParser.h
//  OptionParser
//
//  Created by Heiko Witte on 13.12.16.
//  Copyright © 2016 fournova Software GmbH. All rights reserved.
//

#import <Foundation/Foundation.h>

extern NSString * _Nonnull const FNOptionParserErrorDomain;

typedef NS_ENUM(NSInteger, FNOptionParserErrorCode) {
    FNOptionParserMissingRequiredOptionsError = 1,
    FNOptionParserUnknownOptionError
};

@class FNOption;
@class FNOptionCommand;
@class FNOptionParserResultItem;
@interface FNOptionParser : NSObject
@property (nonatomic, readonly, nonnull) NSArray<FNOption *> *options;
@property (nonatomic, readonly, nonnull) NSArray<FNOption *> *requiredOptions;
@property (nonatomic, readonly, nonnull) NSArray<FNOptionCommand *> *commands;
@property (nonatomic, readonly, nonnull) NSString *usage;
@property (nonatomic, readonly, nullable) NSString *help;
@property (nonatomic, readonly, nonnull) NSString *executableName;
@property (nonatomic, readonly, nullable) NSArray<NSString *> *argumentNames;
@property (nonatomic, nonnull) NSString *listSeparator;

+ (nullable instancetype)parserWithOptions:(nonnull NSArray<FNOption *> *)options commands:(nullable NSArray<FNOptionCommand *> *)commands executableName:(nonnull NSString *)name argumentNames:(nullable NSArray<NSString *> *)argumentNames;
- (nullable id)initWithCommandLineOptions:(nonnull NSArray<FNOption *> *)options commands:(nullable NSArray<FNOptionCommand *> *)commands executableName:(nonnull NSString *)name argumentNames:(nullable NSArray<NSString *> *)argumentNames;

- (nullable NSArray<FNOptionParserResultItem *> *)parseString:(nonnull NSString *)string error:(NSError * _Nullable __autoreleasing * _Nullable)error;
- (nullable NSArray<FNOptionParserResultItem *> *)parseArguments:(nonnull NSArray<NSString *> *)arguments error:(NSError * _Nullable __autoreleasing * _Nullable)error;
@end
