//
//  NSManagedObject+FNCoreData.h
//  FNFoundation
//
//  Created by Alexander Rinaß on 22.02.12.
//  Copyright (c) 2012 Fournova GmbH. All rights reserved.
//

#import <CoreData/CoreData.h>

@interface NSManagedObject (FNCoreData)

/** @name Retrieving Entity Information */

+ (NSString *)entityName;

/** @name Creating Managed Objects */

+ (instancetype)managedObjectWithObjectID:(NSManagedObjectID *)objectID managedObjectContext:(NSManagedObjectContext *)managedObjectContext;
+ (instancetype)createWithManagedObjectContext:(NSManagedObjectContext *)managedObjectContext;
+ (instancetype)createWithManagedObjectContext:(NSManagedObjectContext *)managedObjectContext attributes:(NSDictionary *)attributes;
- (instancetype)initWithManagedObjectContext:(NSManagedObjectContext *)managedObjectContext;

/** @name Refreshing ManagedObjects */

- (void)refreshMergingChanges:(BOOL)mergeChanges;

/** @name Deleting ManagedObjects */

- (void)destroy;
- (BOOL)isDestroyed;

/** @name Saving ManagedObjects */

- (BOOL)save:(NSError * __autoreleasing *)error;

@end
