//
//  FNGitCommandErrorDefinition.h
//  FNGit
//
//  Created by Alexander Rinass on 29/04/14.
//  Copyright (c) 2014 Fournova GmbH. All rights reserved.
//

#import <Foundation/Foundation.h>
#import <FNFoundation/FNFoundation.h>

@interface FNGitCommandErrorDefinition : NSObject
@property (nonatomic, copy, readonly) NSString *name;
@property (nonatomic) NSInteger errorCode;
@property (nonatomic, copy) NSArray *commandNames;
@property (nonatomic, copy) NSArray *subCommandNames;
@property (nonatomic, copy) NSArray *commandArguments;
@property (nonatomic, copy) NSArray *exitCodes;
@property (nonatomic, copy) NSArray *standardErrorPatterns;
@property (nonatomic, copy) NSArray *standardErrorMatchedComponentNames;
@property (nonatomic, copy) NSArray *standardOutputPatterns;
@property (nonatomic, copy) NSArray *standardOutputMatchedComponentNames;

/** @name Creating Instances */

+ (instancetype)gitCommandErrorDefinitionWithDefinition:(NSDictionary *)definition;

- (instancetype)initWithName:(NSString *)name;
- (instancetype)initWithName:(NSString *)name cache:(NSCache *)cache;

/** @name Performing Matches */

- (BOOL)isMatchedByCommandName:(NSString *)commandName;
- (BOOL)isMatchedBySubCommandName:(NSString *)subCommandName;
- (BOOL)isMatchedByExitCode:(NSInteger)exitCode;
- (BOOL)isMatchedByStandardError:(NSString *)standardError;
- (BOOL)isMatchedByStandardOutput:(NSString *)standardOutput;

- (NSDictionary *)matchedComponentsForStandardError:(NSString *)standardError;
- (NSDictionary *)matchedComponentsForStandardOutput:(NSString *)standardOutput;

@end
