//
//  FNGitSequenceInstruction.h
//  FNGit
//
//  Created by Alexander Rinass on 18/08/16.
//  Copyright © 2016 Fournova GmbH. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "FNGitSequenceInstructionCommands.h"

@interface FNGitSequenceInstruction : NSObject
@property (nonatomic, nonnull, readonly) NSString *command;
@property (nonatomic, nonnull, readonly) NSString *commitHash;
@property (nonatomic, nonnull, readonly) NSString *stringValue;

+ (nullable instancetype)new NS_UNAVAILABLE;
+ (nullable instancetype)sequenceInstructionWithCommand:(nonnull NSString *)command commitHash:(nonnull NSString *)commitHash;

- (nullable instancetype)init NS_UNAVAILABLE;
- (nullable instancetype)initWithCommand:(nonnull NSString *)command commitHash:(nonnull NSString *)commitHash;

@end
