//
//  FNGitSubmoduleConfigManager.h
//  FNGit
//
//  Created by Alexander Rinass on 22.10.13.
//  Copyright (c) 2013 Fournova GmbH. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "FNGitDefines.h"
#import "FNGitSubmoduleIgnoreMode.h"
#import "FNGitSubmoduleUpdateStrategy.h"
#import "FNGitSubmoduleRecurseSubmodulesOption.h"
#import "FNGitSubmoduleConfigType.h"

@class FNGitRepository;
@interface FNGitSubmoduleConfigManager : NSObject
@property (nonatomic, readonly) FNGitRepository *repository;
@property (nonatomic, readonly) FNGitSubmoduleConfigType configType;

/** @name Creating Instances */

+ (instancetype)defaultManagerWithRepository:(FNGitRepository *)repository;
+ (instancetype)localConfigManagerWithRepository:(FNGitRepository *)repository;

- (instancetype)initWithRepository:(FNGitRepository *)repository configType:(FNGitSubmoduleConfigType)configType;

/** @name Managing Config Values */

- (BOOL)setPath:(NSString *)submodulePath forSubmoduleWithName:(NSString *)submoduleName error:(NSError * __autoreleasing *)error;
- (BOOL)setURL:(NSString *)submoduleURL forSubmoduleWithName:(NSString *)submoduleName error:(NSError * __autoreleasing *)error;
- (BOOL)setUpdateStrategy:(FNGitSubmoduleUpdateStrategy)updateStrategy forSubmoduleWithName:(NSString *)submoduleName error:(NSError * __autoreleasing *)error;
- (BOOL)setStatusIgnoreMode:(FNGitSubmoduleStatusIgnoreMode)statusIgnoreMode forSubmoduleWithName:(NSString *)submoduleName error:(NSError * __autoreleasing *)error;
- (BOOL)setBranch:(NSString *)branch forSubmoduleWithName:(NSString *)submoduleName error:(NSError * __autoreleasing *)error;
- (BOOL)setRecurseSubmodulesOption:(FNGitSubmoduleRecurseSubmodulesOption)recurseSubmodules forSubmoduleWithName:(NSString *)submoduleName error:(NSError * __autoreleasing *)error;

- (BOOL)unsetURLForSubmoduleWithName:(NSString *)submoduleName error:(NSError * __autoreleasing *)error;
- (BOOL)unsetUpdateStrategyForSubmoduleWithName:(NSString *)submoduleName error:(NSError * __autoreleasing *)error;
- (BOOL)unsetStatusIgnoreModeForSubmoduleWithName:(NSString *)submoduleName error:(NSError * __autoreleasing *)error;
- (BOOL)unsetBranchForSubmoduleWithName:(NSString *)submoduleName error:(NSError * __autoreleasing *)error;
- (BOOL)unsetRecurseSubmodulesOptionForSubmoduleWithName:(NSString *)submoduleName error:(NSError * __autoreleasing *)error;

/** @name Managing Submodule Sections */

- (BOOL)renameConfigSectionForSubmoduleWithName:(NSString *)submoduleName toNewName:(NSString *)newSubmoduleName error:(NSError * __autoreleasing *)error;
- (BOOL)removeConfigSectionForSubmoduleWithName:(NSString *)submoduleName error:(NSError * __autoreleasing *)error;

@end
