//
//  BitbucketRepository.h
//  BitbucketAPI
//
//  Created by Patrick Dinger on 07.02.13.
//  Copyright (c) 2013 Fournova GmbH. All rights reserved.
//

#import <FNFoundation/FNFoundation.h>

extern NSString *const BitbucketAPIRepositorySCMTypeGit;
extern NSString *const BitbucketAPIRepositorySCMTypeMercurial;

@class BitbucketAPIUser;
@interface BitbucketAPIRepository : FNRESTAPIModel
@property (nonatomic, readonly) NSString *repositoryID;

/**
 The title of the repository, which may contain whitespace and special characters.
 */
@property (nonatomic) NSString *title;

/**
 The name of the repository, derived from `fullName`, e.g. “user/repo” => “repo”.
 */
@property (nonatomic) NSString *name;

/**
 The full name or “path” of a repository, e.g. “user/repo”. 
 May only consist of standard URL characters.
 */
@property (nonatomic, readonly) NSString *fullName;
@property (nonatomic) NSString *scm;
@property (nonatomic, readonly) NSString *language;
@property (nonatomic) NSString *userDescription;
@property (nonatomic, getter = isPrivate) BOOL private;
@property (nonatomic, readonly) NSURL *htmlURL;
@property (nonatomic, readonly) NSURL *httpURL;
@property (nonatomic, readonly) NSString *sshURL;
@property (nonatomic, readonly, getter = isForked) BOOL forked;
@property (nonatomic, readonly) NSURL *forkURL;
@property (nonatomic, readonly) NSDate *updatedDate;
@property (nonatomic, readonly) NSDate *creationDate;
@property (nonatomic) BOOL hasIssues;
@property (nonatomic) BOOL hasWiki;
@property (nonatomic, readonly) BitbucketAPIRepository *parent;
@property (nonatomic, readonly) BitbucketAPIUser *owner;

+ (instancetype)repositoryWithJSONObject:(NSDictionary *)JSONObject;

- (BOOL)isEqualToBitbucketAPIRepository:(BitbucketAPIRepository *)object;

@end
