//
//  FNTreeNode.h
//  FNFoundation
//
//  Created by Heiko Witte on 22.03.16.
//  Copyright © 2016 fournova Software GmbH. All rights reserved.
//

#import <Foundation/Foundation.h>

@interface FNTreeNode : NSObject <NSCopying>
@property (nonatomic, copy) NSString *identifier;
@property (nonatomic, copy) NSString *title;
@property (nonatomic) id representedObject;

@property (nonatomic, readonly, weak) FNTreeNode *parentNode;
@property (nonatomic, readonly) NSArray<FNTreeNode *> *childNodes;
@property (nonatomic, readonly) NSUInteger numberOfChildren;
@property (nonatomic, readonly, getter=isLeaf) BOOL leaf;

+ (instancetype)nodeWithIdentifier:(NSString *)identifier;

- (instancetype)initWithIdentifier:(NSString *)identifier;
- (instancetype)initWithRepresentedObject:(id)representedObject;

- (void)addChild:(FNTreeNode *)child;
- (void)addChildrenFromArray:(NSArray<FNTreeNode *> *)children;
- (void)insertChild:(FNTreeNode *)child atIndex:(NSUInteger)index;
- (void)removeChild:(FNTreeNode *)child;
- (void)removeChildAtIndex:(NSUInteger)index;
- (void)removeAllChildren;
- (void)replaceChildNodeAtIndex:(NSUInteger)index withNode:(FNTreeNode *)node;
- (void)moveChildAtIndex:(NSUInteger)index toIndex:(NSUInteger)newIndex;
- (void)swapChildAtIndex:(NSUInteger)leftIndex withChildAtIndex:(NSUInteger)rightIndex;
- (NSUInteger)indexOfChild:(FNTreeNode *)child;

- (NSString *)longDescription;
@end
