//
//  NSManagedObjectContext+FNCoreDataStore.h
//  FNFoundation
//
//  Created by Alexander Rinass on 18/03/15.
//  Copyright (c) 2015 Fournova GmbH. All rights reserved.
//

#import <CoreData/CoreData.h>

/**
 Convenience methods to access contexts provided by CoreDataStore.
 */
@interface NSManagedObjectContext (FNCoreDataStore)

/**
 Returns the main context that is used on the main queue
 (NSMainQueueConcurrencyType).
 
 Always use `performBlock:` or `performBlockAndWait:` to perform tasks on this
 context.
 */
+ (NSManagedObjectContext *)mainContext;

+ (NSManagedObjectContext *)backgroundContext;

@end
