//
//  FNGitSubmoduleConfigHelper.h
//  FNGit
//
//  Created by Alexander Rinass on 22.10.13.
//  Copyright (c) 2013 Fournova GmbH. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "FNGitSubmoduleIgnoreMode.h"
#import "FNGitSubmoduleUpdateStrategy.h"
#import "FNGitSubmoduleRecurseSubmodulesOption.h"

@interface FNGitSubmoduleConfigHelper : NSObject

+ (FNGitSubmoduleUpdateStrategy)updateStrategyFromConfigValue:(NSString *)value;
+ (NSString *)updateStrategyToConfigValue:(FNGitSubmoduleUpdateStrategy)updateStrategy;

+ (FNGitSubmoduleStatusIgnoreMode)statusIgnoreModeFromConfigValue:(NSString *)value;
+ (NSString *)statusIgnoreModeToConfigValue:(FNGitSubmoduleStatusIgnoreMode)statusIgnoreMode;

+ (FNGitSubmoduleRecurseSubmodulesOption)recurseSubmodulesOptionFromConfigValue:(NSString *)value;
+ (NSString *)recurseSubmodulesOptionToConfigValue:(FNGitSubmoduleRecurseSubmodulesOption)recurseSubmodulesOption;

+ (NSString *)submoduleConfigSectionWithSubmoduleName:(NSString *)submoduleName;
+ (NSString *)submoduleConfigKeyWithSubmoduleName:(NSString *)submoduleName configKey:(NSString *)configKey;

+ (NSDictionary *)configValuesWithLowercaseConfigKeysFromConfigValues:(NSDictionary *)configValues;

@end
