//
//  GitHubAPISearchRepositoriesRequestOperation.h
//  GitHubAPI
//
//  Created by Alexander Rinass on 30/10/15.
//  Copyright © 2015 Fournova GmbH. All rights reserved.
//

#import "GitHubAPIRequestOperation.h"

@interface GitHubAPISearchRepositoriesRequestOperation : GitHubAPIRequestOperation
@property (nonatomic, readonly) NSString *searchString;
@property (nonatomic, readonly) NSDictionary *options;
@property (nonatomic, readonly) NSArray *repositories;

+ (instancetype)requestWithCredentials:(GitHubAPICredentials *)credentials searchString:(NSString *)searchString options:(NSDictionary *)options;
- (instancetype)initWithCredentials:(GitHubAPICredentials *)credentials searchString:(NSString *)searchString options:(NSDictionary *)options;

@end
