//
//  BeanstalkPublicKey.h
//  BeanstalkAPI
//
//  Created by Alexander Rinaß on 12.06.12.
//  Copyright (c) 2012 Fournova GmbH. All rights reserved.
//

#import <FNFoundation/FNFoundation.h>

@interface BeanstalkAPIPublicKey : FNRESTAPIModel
@property (nonatomic, readonly) NSInteger publicKeyID;
@property (nonatomic, readonly) NSInteger accountID;
@property (nonatomic, readonly) NSInteger userID;
@property (nonatomic) NSString *name;
@property (nonatomic) NSString *content;
@property (nonatomic, readonly) NSDate *updatedDate;
@property (nonatomic, readonly) NSDate *creationDate;

+ (instancetype)publicKeyWithJSONObject:(NSDictionary *)JSONObject;

- (BOOL)isEqualToBeanstalkAPIPublicKey:(BeanstalkAPIPublicKey *)object;

@end
