//
//  BeanstalkRepository.h
//  BeanstalkAPI
//
//  Created by Alexander Rinaß on 12.06.12.
//  Copyright (c) 2012 Fournova GmbH. All rights reserved.
//

#import <FNFoundation/FNFoundation.h>

extern NSString *const BeanstalkAPIVCSTypeSubversion;
extern NSString *const BeanstalkAPIVCSTypeGit;

@interface BeanstalkAPIRepository : FNRESTAPIModel
@property (nonatomic, readonly) NSInteger repositoryID;
@property (nonatomic, readonly) NSInteger accountID;
@property (nonatomic) NSString *title;
@property (nonatomic) NSString *name;
@property (nonatomic, readonly) NSString *defaultBranch;
@property (nonatomic) NSString *colorLabel;
@property (nonatomic, readonly) NSString *vcs;
@property (nonatomic) NSString *vcsType;
@property (nonatomic, readonly) NSString *sshURL;
@property (nonatomic, readonly) NSURL *httpURL;
@property (nonatomic, readonly) NSDate *lastCommitDate;
@property (nonatomic, readonly) NSDate *updatedDate;
@property (nonatomic, readonly) NSDate *creationDate;

+ (instancetype)repositoryWithJSONObject:(NSDictionary *)JSONObject;

- (BOOL)isEqualToBeanstalkAPIRepository:(BeanstalkAPIRepository *)object;

@end
