//
//  NSError+BitbucketAPI.h
//  BitbucketAPI
//
//  Created by Patrick Dinger on 07.02.13.
//  Copyright (c) 2013 Fournova GmbH. All rights reserved.
//

#import <Foundation/Foundation.h>

extern NSString *const BitbucketAPIErrorDomain;

extern NSString *const BitbucketAPIRequestURLErrorKey;
extern NSString *const BitbucketAPIRequestPathErrorKey;
extern NSString *const BitbucketAPIRequestBodyErrorKey;
extern NSString *const BitbucketAPIRequestHeadersErrorKey;

extern NSString *const BitbucketAPIResponseStatusCodeErrorKey;
extern NSString *const BitbucketAPIResponseHeadersErrorKey;
extern NSString *const BitbucketAPIResponseBodyErrorKey;

extern NSString *const BitbucketAPIErrorMessageErrorKey;
extern NSString *const BitbucketAPIErrorDetailErrorKey;
extern NSString *const BitbucketAPIErrorValidationFieldTitleErrorKey;
extern NSString *const BitbucketAPIErrorValidationErrorMessageErrorKey;

enum {
    BitbucketAPIGenericError = 1, // Generic API Error
    BitbucketAPIConnectionError,
    BitbucketAPIParseError,
    BitbucketAPIValidationError,
    
    BitbucketAPIBadRequestError = 400,
    BitbucketAPIAuthenticationError = 401,
    BitbucketAPIForbiddenError = 403,
    BitbucketAPINotFoundError = 404,
    BitbucketAPIMethodNotAllowedError = 405,
    BitbucketAPIConflictError = 409,
    BitbucketAPIUnprocessableEntityError = 422,
    BitbucketAPIServerError = 500
};

@interface NSError (BitbucketAPI)

+ (instancetype)bitbucketAPIErrorWithCode:(NSInteger)code userInfo:(NSDictionary *)userInfo;
+ (instancetype)bitbucketAPIConnectionErrorWithNSURLError:(NSError *)NSURLError userInfo:(NSDictionary *)userInfo;
+ (instancetype)bitbucketAPIParseErrorWithError:(NSError *)error userInfo:(NSDictionary *)userInfo;
+ (instancetype)bitbucketAPIValidationErrorWithFieldTitle:(NSString *)fieldTitle errorMessage:(NSString *)errorMessage;

@end
