//
//  FNListChangeset.h
//  FNFoundation
//
//  Created by Heiko Witte on 22.03.16.
//  Copyright © 2016 fournova Software GmbH. All rights reserved.
//

#import <Foundation/Foundation.h>

@class FNListChange;
@interface FNListChangeset : NSObject
@property (nonatomic, readonly) NSArray<FNListChange *> *insertedItems;
@property (nonatomic, readonly) NSArray<FNListChange *> *deletedItems;
@property (nonatomic, readonly) NSArray<FNListChange *> *movedItems;

- (void)addChange:(FNListChange *)change;
- (BOOL)hasMoveForKey:(NSString *)key;
- (BOOL)hasDeleteForKey:(NSString *)key;
@end
