//
//  FNObserver.h
//  FNFoundation
//
//  Created by Alexander Rinass on 19/04/16.
//  Copyright © 2016 Fournova GmbH. All rights reserved.
//

#import <Foundation/Foundation.h>

@interface FNObserver : NSObject
@property (nonatomic, readonly) id notificationObject;
@property (nonatomic, readonly) id invocationTarget;
@property (nonatomic) NSOperationQueue *queue;

/** @name Starting and Stopping Observing */

- (void)startObserving;
- (void)stopObserving;

/** @name Registering and Unregistering Observers */

- (void)registerObservers;
- (void)registerNotificationWithName:(NSString *)notificationName action:(SEL)action;
- (void)unregisterObservers;

@end
