//
//  FNRESTAPIClient.h
//  FNFoundation
//
//  Created by Heiko Witte on 19.10.16.
//  Copyright © 2016 Fournova GmbH. All rights reserved.
//

#import <Foundation/Foundation.h>

@class FNRESTAPIRequest;
@class FNRESTAPIResponse;
@class FNRESTAPIAuthenticationCredentials;

@interface FNRESTAPIClient : NSObject
@property (nonatomic, nullable) FNRESTAPIAuthenticationCredentials *credentials;

- (nullable FNRESTAPIRequest *)performGETRequestWithURL:(nonnull NSURL *)URL params:(nullable NSDictionary *)params completionHandler:(nullable void (^)(FNRESTAPIResponse * _Nonnull response))completionHandler;
- (nullable FNRESTAPIRequest *)performPOSTRequestWithURL:(nonnull NSURL *)URL params:(nullable NSDictionary *)params completionHandler:(nullable void (^)(FNRESTAPIResponse * _Nonnull response))completionHandler;
- (nullable FNRESTAPIRequest *)performPUTRequestWithURL:(nonnull NSURL *)URL params:(nullable NSDictionary *)params completionHandler:(nullable void (^)(FNRESTAPIResponse * _Nonnull response))completionHandler;

- (void)waitUntilFinished;
@end
