//
//  FNRESTAPIModelPropertyMapping.h
//  FNFoundation
//
//  Created by Alexander Rinass on 27/05/15.
//  Copyright (c) 2015 Fournova GmbH. All rights reserved.
//

#import <Foundation/Foundation.h>

@interface FNRESTAPIModelPropertyMapping : NSObject
@property (nonatomic, readonly) NSString *jsonPropertyName;
@property (nonatomic, readonly) NSString *modelPropertyName;
@property (nonatomic) NSString *valueTransformer;
@property (nonatomic, getter=isWritable) BOOL writable;

+ (instancetype)propertyMappingWithJSONPropertyName:(NSString *)jsonPropertyName modelPropertyName:(NSString *)modelPropertyName;
+ (instancetype)propertyMappingWithJSONPropertyName:(NSString *)jsonPropertyName modelPropertyName:(NSString *)modelPropertyName writable:(BOOL)writable;
+ (instancetype)propertyMappingWithJSONPropertyName:(NSString *)jsonPropertyName modelPropertyName:(NSString *)modelPropertyName valueTransformer:(NSString *)valueTransformer;
+ (instancetype)propertyMappingWithJSONPropertyName:(NSString *)jsonPropertyName modelPropertyName:(NSString *)modelPropertyName valueTransformer:(NSString *)valueTransformer writable:(BOOL)writable;
- (instancetype)initWithJSONPropertyName:(NSString *)jsonPropertyName modelPropertyName:(NSString *)modelPropertyName;

@end
