//
//  FNGitCommandEnvironment.h
//  FNGit
//
//  Created by Alexander Rinass on 17/05/16.
//  Copyright © 2016 Fournova GmbH. All rights reserved.
//

#import <Foundation/Foundation.h>

@interface FNGitCommandEnvironment : NSObject
@property (nonatomic, nonnull, readonly) NSDictionary *dictionaryRepresentation;

+ (nullable instancetype)sharedEnvironment;

- (nullable NSString *)valueForEnvironmentVariable:(nonnull NSString *)environmentVariable;
- (void)setValue:(nullable NSString *)value forEnvironmentVariable:(nonnull NSString *)environmentVariable;
- (void)unsetValueForEnvironmentVariable:(nonnull NSString *)environmentVariable;
- (void)setValuesFromDictionary:(nonnull NSDictionary *)environment;

@end
