//
//  FNGitDiffTool.h
//  FNGit
//
//  Created by Alexander Rinass on 09.09.13.
//  Copyright (c) 2013 Fournova GmbH. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "FNGitDefines.h"

@class FNGitRepository;
@interface FNGitDiffTool : NSObject
@property (nonatomic, readonly) FNGitRepository *repository;
@property (nonatomic, readonly) NSString *name;
@property (nonatomic, readonly) NSInteger exitCode;
@property (nonatomic, readonly) NSString *standardOutput;
@property (nonatomic, readonly) NSString *standardError;

+ (instancetype)diffToolWithRepository:(FNGitRepository *)repository name:(NSString *)name;

- (instancetype)init NS_UNAVAILABLE;
- (instancetype)initWithRepository:(FNGitRepository *)repository name:(NSString *)name;

- (void)launchWithRevisions:(NSArray *)revisions filePaths:(NSArray *)filePaths options:(FNGitDiffToolOptions)options completionHandler:(void (^)(NSInteger exitCode, NSError *error))completionHandler;
- (void)cancel;

@end
