//
//  NSError+FNGit.h
//  FNGit
//
//  Created by Alexander Rinass on 26.05.11.
//  Copyright 2011 Fournova GmbH. All rights reserved.
//

#import <Foundation/Foundation.h>

/** @name Error Domain */

extern NSString *const FNGitErrorDomain;

/** @name Error UserInfo Keys */

extern NSString *const FNGitBinaryVersionErrorKey;
extern NSString *const FNGitCommandCallErrorKey;
extern NSString *const FNGitErrorOutputErrorKey;
extern NSString *const FNGitCommandExitCodeErrorKey;
extern NSString *const FNGitCommandErrorOutputErrorKey;
extern NSString *const FNGitCommandStandardOutputErrorKey;
extern NSString *const FNGitCommandEnvironmentErrorKey;
extern NSString *const FNGitConfigFileErrorKey;
extern NSString *const FNGitConfigKeyErrorKey;
extern NSString *const FNGitConfigValueErrorKey;
extern NSString *const FNGitConfigNewSectionNameErrorKey;
extern NSString *const FNGitConfigSectionNameErrorKey;
extern NSString *const FNGitDestinationFilePathErrorKey;
extern NSString *const FNGitFilePathErrorKey;
extern NSString *const FNGitFilePathsErrorKey;
extern NSString *const FNGitIgnoresPathErrorKey;
extern NSString *const FNGitNewRefNameErrorKey;
extern NSString *const FNGitNewRemoteNameErrorKey;
extern NSString *const FNGitNewSubmoduleNameErrorKey;
extern NSString *const FNGitObjectHashErrorKey;
extern NSString *const FNGitObjectReferenceErrorKey;
extern NSString *const FNGitOutputParserNameErrorKey;
extern NSString *const FNGitOutputParserLineErrorKey;
extern NSString *const FNGitPatchErrorKey;
extern NSString *const FNGitPatchLineNumberErrorKey;
extern NSString *const FNGitRebaseCurrentStepErrorKey;
extern NSString *const FNGitRebaseLastStepErrorKey;
extern NSString *const FNGitRebaseSubjectErrorKey;
extern NSString *const FNGitRefNameErrorKey;
extern NSString *const FNGitRefSpecErrorKey;
extern NSString *const FNGitRemoteNameErrorKey;
extern NSString *const FNGitRemoteURLErrorKey;
extern NSString *const FNGitRepositoryPathErrorKey;
extern NSString *const FNGitRevisionErrorKey;
extern NSString *const FNGitSourceFilePathErrorKey;
extern NSString *const FNGitSubmoduleNameErrorKey;
extern NSString *const FNGitSubmodulePathErrorKey;
extern NSString *const FNGitStashIndexErrorKey;

/** @name Error Codes */

typedef NS_ENUM(NSInteger, FNGitError) {
    FNGitGenericError = 1,
    
    FNGitCommandUsageError = 10,
    FNGitOutputParserError,
    
    // Common Errors
    FNGitNoGitRepoError = 100,
    FNGitNoRefsError,
    FNGitNoWorkTreeError,
    FNGitIndexLockError,
    FNGitRefsReadError,
    FNGitBadDefaultRevisionError,
    FNGitBadRevisionError,
    FNGitNoCommitsError,
    
    // Common Synchronization Errors
    FNGitAskpassError = 200,
    FNGitRemoteSyncError,
    FNGitRemoteAuthError,
    FNGitRemoteRepositoryNotFoundError,
    FNGitRemoteConnectionError,
    
    // Description File Read/Write Errors
    FNGitDescriptionReadError = 300,
    FNGitDescriptionWriteError,
    
    // Ignores Files Read/Write Errors
    FNGitIgnoresReadError = 400,
    FNGitIgnoresWriteError,
    
    // git config
    FNGitConfigBadValueError = 1000,
    FNGitConfigInvalidFileError,
    FNGitConfigKeyNotFoundError,
    FNGitConfigMultipleValuesForKeyError,
    FNGitConfigReadError,
    FNGitConfigSectionNotFoundError,
    FNGitConfigWriteError,
    
    // git init
    FNGitInitRepositoryFileExistsError = 1100,
    FNGitInitRepositoryPathNotWritableError,
    FNGitInitRepositoryInvalidPathError,
    
    // git show
    FNGitBlobReadError = 1200,
    FNGitBlobNotFoundError,
    
    // git add
    FNGitAddFilesError = 1300,
    
    // git apply
    FNGitApplyPatchCorruptError = 1400,
    FNGitApplyPatchWithNoChangesError,
    FNGitApplyPatchWithNoTargetError,
    
    // git archive
    FNGitArchiveFilesError = 1500,
    
    // git checkout
    FNGitCheckoutUncommittedChangesError = 1600,
    
    // git tag
    FNGitCreateTagAlreadyExistsError = 1700,
    FNGitCreateTagInvalidObjectError,
    FNGitDeleteTagNotFoundError,
    
    // git svn
    FNGitSVNInstallationError = 1800,
    FNGitSVNCertificateError = 1801,
    
    // git log
    FNGitLogNoSuchRevisionError = 1900,
    
    // git merge(+pull|cherry-pick|revert)
    FNGitMergeConflictsError = 2000,
    FNGitMergeUncommittedChangesError,
    FNGitMergeUnmergedChangesError,
    FNGitMergetoolMergeFailedError,
    FNGitNoDefaultMergeBranchError,
    
    // git move
    FNGitMoveFileAlreadyExistsError = 2100,
    FNGitMoveFileDestinationDirectoryMissingError,
    FNGitMoveFileNotUnderVersionControlError,
    FNGitMoveFileOutsideRepositoryError,
    FNGitMoveFileSelfTargetError,
    FNGitMoveFileSourceDirectoryEmptyError,
    FNGitMoveFileSourceNotFoundError,
    
    // git rebase
    FNGitRebaseConflictsError = 2200,
    FNGitRebaseUncommittedChangesError,
    FNGitRebaseUnmergedChangesError,
    
    // git remote
    FNGitCreateRemoteAlreadyExistsError = 2300,
    FNGitCreateRemoteInvalidNameError,
    FNGitRenameRemoteAlreadyExistsError,
    FNGitRenameRemoteInvalidNameError,
    
    // git push
    FNGitRemotePushNoUpstreamBranchError = 2400,
    FNGitRemotePushRejectedError,
    
    // git branch
    FNGitCreateBranchFromStashInvalidNameError = 2500,
    FNGitCreateBranchFromStashNotFoundError,
    FNGitCreateBranchFromStashNoStashesError,
    FNGitCreateBranchFromStashUncommittedChangesError,
    FNGitCreateBranchInvalidNameError,
    FNGitCreateBranchInvalidObjectError,
    FNGitCreateBranchRefAlreadyExistsError,
    FNGitRenameBranchInvalidObjectError,
    FNGitRenameBranchRefAlreadyExistsError,
    FNGitTrackBranchInvalidObjectError,
    FNGitDeleteBranchNoSuchBranchError,
    FNGitDeleteCurrentBranchError,
    FNGitDeleteUnmergedBranchError,

    // git rm
    FNGitRemoveOperationNotPermittedError = 2600,
    FNGitRemoveFileWithLocalModificationsError,
    FNGitRemoveSubmoduleWithLocalModificationsError,
    
    // git stash
    FNGitSaveStashInitialCommitError = 2700,
    FNGitApplyStashMergeConflictsError,
    FNGitApplyStashNotFoundError,
    FNGitApplyStashNoStashesError,
    FNGitApplyStashUncommittedChangesError,
    FNGitDropStashNotFoundError,
    FNGitDropStashNoStashesError,
    
    // git submodule
    FNGitSubmoduleStatusMissingMappingError = 2800,
    FNGitSubmoduleStatusMissingGitDirError,
    FNGitAddSubmodulePathOutsideRepositoryError,
    FNGitAddSubmodulePathAlreadyExistsError,
    FNGitAddSubmoduleGitDirectoryAlreadyExistsError,
    
    // git ls-tree Errors
    FNGitTreeNotATreeObjectError = 2900,
    FNGitTreeNotFoundError,
    
    // git update-index Errors
    FNGitUpdateIndexNoSuchFileError = 3000,

    // git reset
    FNGitResetInvalidRefError = 3100,
};

@class FNGitCommand;
@interface NSError (FNGit)

+ (instancetype)gitErrorWithCode:(NSInteger)code userInfo:(NSDictionary *)userInfo;
+ (instancetype)gitErrorWithCommand:(FNGitCommand *)command userInfo:(NSDictionary *)userInfo;

@end
