//
//  GitHubAPIRequestOperation.h
//  GitHubAPI
//
//  Created by Alexander Rinass on 19.06.12.
//  Copyright (c) 2012 Fournova GmbH. All rights reserved.
//

#import <FNFoundation/FNFoundation.h>
#import "GitHubAPIConstants.h"
#import "GitHubAPIModels.h"
#import "GitHubAPIJSONParsers.h"
#import "GitHubAPIHelpers.h"

@class GitHubAPIResponse;

typedef void (^GitHubAPIRequestCompletionHandler)(GitHubAPIResponse *response);

@class GitHubAPICredentials;
@interface GitHubAPIRequestOperation : FNRESTAPIRequestOperation
@property (nonatomic, readonly) GitHubAPICredentials *credentials;
@property (nonatomic, copy) GitHubAPIRequestCompletionHandler completionHandler;
@property (nonatomic) id result;
@property (nonatomic, readonly) GitHubAPIResponse *APIResponse;

+ (NSDictionary *)defaultOptions;

- (instancetype)initWithCredentials:(GitHubAPICredentials *)credentials method:(NSString *)method path:(NSString *)path params:(NSDictionary *)params;

@end
