//
//  BitbucketAPIClient.h
//  BitbucketAPI
//
//  Created by Patrick Dinger on 07.02.13.
//  Copyright (c) 2013 Fournova GmbH. All rights reserved.
//

#import <Foundation/Foundation.h>

@class BitbucketAPICredentials;
@class BitbucketAPIRequest;
@class BitbucketAPIResponse;
@class BitbucketAPIRequestOperation;
@class BitbucketAPIUser;
@class BitbucketAPIRepository;
@class BitbucketAPIGroup;
@interface BitbucketAPIClient : NSObject
@property (nonatomic) BitbucketAPICredentials *credentials;
@property (nonatomic) NSString *userAgentString;

+ (instancetype)clientWithCredentials:(BitbucketAPICredentials *)credentials;
- (instancetype)initWithCredentials:(BitbucketAPICredentials *)credentials;

/** @name Enqueuing and Executing API Requests */

- (BitbucketAPIRequest *)enqueueRequest:(BitbucketAPIRequestOperation *)request completionHandler:(void (^)(BitbucketAPIResponse *response))completionHandler;

- (void)cancelAllRequests;
- (NSArray *)allRequests;

/** @name Executing User API Requests */

- (BitbucketAPIRequest *)fetchCurrentUserWithCompletionHandler:(void (^)(BitbucketAPIResponse *response))completionHandler;
- (BitbucketAPIRequest *)fetchUserForUsername:(NSString *)username completionHandler:(void (^)(BitbucketAPIResponse *response))completionHandler;

/** @name Executing Repository API Requests */

- (BitbucketAPIRequest *)fetchAllRepositoriesWithPaginationURL:(NSURL *)paginationURL completionHandler:(void (^)(BitbucketAPIResponse *response))completionHandler;
- (BitbucketAPIRequest *)fetchAllRepositoriesForCurrentUserWithOptions:(NSDictionary *)options completionHandler:(void (^)(BitbucketAPIResponse *response))completionHandler;
- (BitbucketAPIRequest *)fetchAllRepositoriesForUserWithUsername:(NSString *)username options:(NSDictionary *)options completionHandler:(void (^)(BitbucketAPIResponse *response))completionHandler;
- (BitbucketAPIRequest *)fetchAllRepositoriesForTeamWithTeamName:(NSString *)teamName options:(NSDictionary *)options completionHandler:(void (^)(BitbucketAPIResponse *response))completionHandler;

- (BitbucketAPIRequest *)fetchRepositoryWithName:(NSString *)repositoryName forUserWithUsername:(NSString *)username completionHandler:(void (^)(BitbucketAPIResponse *response))completionHandler;

- (BitbucketAPIRequest *)createRepository:(BitbucketAPIRepository *)repository completionHandler:(void (^)(BitbucketAPIResponse *response))completionHandler;
- (BitbucketAPIRequest *)createRepository:(BitbucketAPIRepository *)repository forUserWithName:(NSString *)username completionHandler:(void (^)(BitbucketAPIResponse *response))completionHandler;

/** @name Executing Team API Requests */

- (BitbucketAPIRequest *)fetchTeamWithTeamName:(NSString *)teamName completionHandler:(void (^)(BitbucketAPIResponse *response))completionHandler;
- (BitbucketAPIRequest *)fetchAllTeamsForCurrentUserWithOptions:(NSDictionary *)options completionHandler:(void (^)(BitbucketAPIResponse *response))completionHandler;

@end
