//
//  FNHTTPAPIRequestOperation.h
//  FNFoundation
//
//  Created by Alexander Rinass on 17.06.12.
//  Copyright (c) 2012 Fournova GmbH. All rights reserved.
//

#import <Foundation/Foundation.h>

@class FNHTTPResponse;
@interface FNRESTAPIRequestOperation : NSOperation
@property (nonatomic, readonly) NSMutableURLRequest *request;
@property (nonatomic, readonly) NSHTTPURLResponse *response;
@property (nonatomic, readonly) NSData *responseData;
@property (nonatomic, readonly) NSError *error;
@property (nonatomic, readonly) NSURLRequestCachePolicy requestCachePolicy;
@property (nonatomic, readonly) NSTimeInterval requestTimeoutInterval;
@property (nonatomic) BOOL trustsServer;
@property (nonatomic) NSData *serverTrustExceptionCookie;

- (instancetype)init NS_UNAVAILABLE;
- (instancetype)initWithURL:(NSURL *)URL;
- (instancetype)initWithURL:(NSURL *)URL HTTPMethod:(NSString *)HTTPMethod;

/** @name Setting Authorization Headers */

- (void)setBasicAuthorizationHeaderWithUsername:(NSString *)username password:(NSString *)password;
- (void)setOAuthAuthorizationHeaderWithToken:(NSString *)token;
- (void)setNTLMAuthorizationWithUsername:(NSString *)username password:(NSString *)password;

/** @name Handling Responses */

- (NSError *)handleConnectionError:(NSError *)error;
- (NSError *)handleAPIErrorResponse:(NSHTTPURLResponse *)response data:(NSData *)responseData;

- (BOOL)validateAPIResponse:(NSHTTPURLResponse *)response data:(NSData *)responseData error:(NSError * __autoreleasing *)error;

- (BOOL)parseResponseData:(NSData *)responseData error:(NSError * __autoreleasing *)error;

/** @name Responding to Events */

- (void)requestDidFinish;

@end
