//
//  FNGitLFSManager.h
//  FNGit
//
//  Created by Heiko Witte on 05.08.16.
//  Copyright © 2016 Fournova GmbH. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "FNGitProtocols.h"
#import "FNGitLFSInstallationMode.h"

@class FNGitRepository;
@class FNGitCommand;
@class FNGitBinary;
@class FNGitLFSTrackingEntry;
@class FNGitLFSPointer;
@class FNGitRemote;

@interface FNGitLFSManager : NSObject
@property (nonatomic, readonly, nonnull) FNGitRepository *repository;
@property (nonatomic, nonnull) FNGitBinary *gitBinary;

- (nullable instancetype)init;
- (nullable instancetype)initWithGitRepository:(nullable FNGitRepository *)repository;

- (BOOL)installGitLFSWithMode:(FNGitLFSInstallationMode)mode options:(nullable NSDictionary *)options error:(NSError * _Nullable __autoreleasing * _Nullable)error;
- (BOOL)uninstallGitLFS:(nullable NSDictionary *)options error:(NSError * _Nullable __autoreleasing * _Nullable)error;

- (nullable NSArray<FNGitLFSTrackingEntry *> *)allTrackingEntries:(nullable NSDictionary *)options error:(NSError * _Nullable __autoreleasing * _Nullable)error;
- (BOOL)addTrackedFilePatterns:(nonnull NSArray<NSString *> *)filePatterns options:(nullable NSDictionary *)options error:(NSError * _Nullable __autoreleasing * _Nullable)error;
- (BOOL)removeTrackedFilePatterns:(nonnull NSArray<NSString *> *)filePatterns options:(nullable NSDictionary *)options error:(NSError * _Nullable __autoreleasing * _Nullable)error;

- (nonnull id<FNGitCommandCancelling>)cloneRepositoryAtURL:(nonnull NSString *)remoteURL localPath:(nonnull NSString *)path options:(nullable NSDictionary *)options environment:(nonnull NSDictionary *)environment progressHandler:(nullable FNGitCommandProgressHandler)progressHandler completionHandler:(nullable void (^)(NSError * _Nullable error))completionHandler;

- (BOOL)fetchRemote:(nonnull FNGitRemote *)remote options:(nullable NSDictionary *)options error:(NSError * _Nullable __autoreleasing * _Nullable)error;
- (nonnull id<FNGitCommandCancelling>)fetchRemote:(nonnull FNGitRemote *)remote options:(nullable NSDictionary *)options progressHandler:(nullable FNGitCommandProgressHandler)progressHandler completionHandler:(nullable void (^)(NSError * _Nullable error))completionHandler;
- (BOOL)pullRemote:(nonnull FNGitRemote *)remote options:(nullable NSDictionary *)options error:(NSError * _Nullable __autoreleasing * _Nullable)error;
- (nonnull id<FNGitCommandCancelling>)pullRemote:(nonnull FNGitRemote *)remote options:(nullable NSDictionary *)options progressHandler:(nullable FNGitCommandProgressHandler)progressHandler completionHandler:(nullable void (^)(NSError * _Nullable error))completionHandler;
- (BOOL)pushRemote:(nonnull FNGitRemote *)remote options:(nullable NSDictionary *)options error:(NSError * _Nullable __autoreleasing * _Nullable)error;
- (nonnull id<FNGitCommandCancelling>)pushRemote:(nonnull FNGitRemote *)remote options:(nullable NSDictionary *)options progressHandler:(nullable FNGitCommandProgressHandler)progressHandler completionHandler:(nullable void (^)(NSError * _Nullable error))completionHandler;

- (BOOL)checkout:(nullable NSDictionary *)options error:(NSError * _Nullable __autoreleasing * _Nullable)error;
- (nonnull id<FNGitCommandCancelling>)checkout:(nullable NSDictionary *)options completionHandler:(nullable void (^)(NSError * _Nullable error))completionHandler;
- (BOOL)prune:(nullable NSDictionary *)options error:(NSError * _Nullable __autoreleasing * _Nullable)error;
- (nonnull id<FNGitCommandCancelling>)prune:(nullable NSDictionary *)options completionHandler:(nullable void (^)(NSError * _Nullable error))completionHandler;
- (nullable NSArray<NSString *> *)allTrackedFiles:(nullable NSDictionary *)options error:(NSError * _Nullable __autoreleasing * _Nullable)error;
- (nullable NSArray<NSString *> *)allTrackedFilesForRevision:(nonnull NSString *)revision options:(nullable NSDictionary *)options error:(NSError * _Nullable __autoreleasing * _Nullable)error;

- (BOOL)update:(nullable NSDictionary *)options error:(NSError * _Nullable __autoreleasing * _Nullable)error;

- (nullable FNGitLFSPointer *)createPointerFromFileAtPath:(nonnull NSString *)filePath options:(nullable NSDictionary *)options error:(NSError * _Nullable __autoreleasing * _Nullable)error;
- (nonnull id<FNGitCommandCancelling>)createPointerFromFileAtPath:(nonnull NSString *)filePath options:(nullable NSDictionary *)options completionHandler:(nullable void (^)(FNGitLFSPointer * _Nullable pointer, NSError * _Nullable error))completionHandler;
- (BOOL)createFileFromPointer:(nonnull FNGitLFSPointer *)pointer outputPath:(nonnull NSString *)path options:(nullable NSDictionary *)options error:(NSError * _Nullable __autoreleasing * _Nullable)error;
- (nonnull id<FNGitCommandCancelling>)createFileFromPointer:(nonnull FNGitLFSPointer *)pointer outputPath:(nonnull NSString *)path options:(nullable NSDictionary *)options completionHandler:(nullable void (^)(NSError * _Nullable error))completionHandler;
- (nullable NSData *)createFileDataFromPointer:(nonnull FNGitLFSPointer *)pointer options:(nullable NSDictionary *)options error:(NSError * _Nullable __autoreleasing * _Nullable)error;
- (nonnull id<FNGitCommandCancelling>)createFileDataFromPointer:(nonnull FNGitLFSPointer *)pointer options:(nullable NSDictionary *)options completionHandler:(nullable void (^)(NSData * _Nullable data, NSError * _Nullable error))completionHandler;

- (nullable FNGitLFSPointer *)pointerFromData:(nonnull NSData *)data;

@end
