//
//  GitHubSSHKey.h
//  Tower
//
//  Created by Alexander Rinass on 12.04.12.
//  Copyright (c) 2012 Fournova GmbH. All rights reserved.
//

#import <FNFoundation/FNFoundation.h>

@interface GitHubAPIPublicKey : FNRESTAPIModel
@property (nonatomic, readonly) NSInteger publicKeyID;
@property (nonatomic) NSString *title;
@property (nonatomic) NSString *key;
@property (nonatomic, readonly) NSDate *creationDate;
@property (nonatomic, readonly) NSURL *apiURL;

+ (instancetype)publicKeyWithJSONObject:(NSDictionary *)JSONObject;

- (BOOL)isEqualToGitHubAPIPublicKey:(GitHubAPIPublicKey *)object;

@end

