//
//  BeanstalkAPIClient.h
//  BeanstalkAPI
//
//  Created by Alexander Rinaß on 13.06.12.
//  Copyright (c) 2012 Fournova GmbH. All rights reserved.
//

#import <Foundation/Foundation.h>

@class BeanstalkAPICredentials;
@class BeanstalkAPIRequest;
@class BeanstalkAPIResponse;
@class BeanstalkAPIRequestOperation;
@class BeanstalkAPIUser;
@class BeanstalkAPIRepository;
@class BeanstalkAPIPublicKey;
@class BeanstalkAPIGroup;
@interface BeanstalkAPIClient : NSObject
@property (nonatomic) BeanstalkAPICredentials *credentials;
@property (nonatomic) NSString *userAgentString;

+ (instancetype)clientWithCredentials:(BeanstalkAPICredentials *)credentials;
- (instancetype)initWithCredentials:(BeanstalkAPICredentials *)credentials;

/** @name Enqueuing and Executing API Requests */

- (BeanstalkAPIRequest *)enqueueRequest:(BeanstalkAPIRequestOperation *)request completionHandler:(void (^)(BeanstalkAPIResponse *response))completionHandler;

- (void)cancelAllRequests;
- (NSArray *)allRequests;

/** @name Executing User API Requests */

- (BeanstalkAPIRequest *)fetchCurrentUserWithCompletionHandler:(void (^)(BeanstalkAPIResponse *response))completionHandler;
- (BeanstalkAPIRequest *)fetchUserForUserID:(NSInteger)userID completionHandler:(void (^)(BeanstalkAPIResponse *response))completionHandler;

/** @name Executing Repository API Requests */

- (BeanstalkAPIRequest *)fetchAllRepositoriesForCurrentUserWithOptions:(NSDictionary *)options completionHandler:(void (^)(BeanstalkAPIResponse *response))completionHandler;
- (BeanstalkAPIRequest *)createRepository:(BeanstalkAPIRepository *)repository completionHandler:(void (^)(BeanstalkAPIResponse *response))completionHandler;

/** @name Executing Public Key API Requests */

- (BeanstalkAPIRequest *)fetchAllPublicKeysForCurrentUserWithOptions:(NSDictionary *)options completionHandler:(void (^)(BeanstalkAPIResponse *response))completionHandler;
- (BeanstalkAPIRequest *)fetchAllPublicKeysForUserWithID:(NSInteger)userID options:(NSDictionary *)options completionHandler:(void (^)(BeanstalkAPIResponse *response))completionHandler;
- (BeanstalkAPIRequest *)createPublicKey:(BeanstalkAPIPublicKey *)publicKey completionHandler:(void (^)(BeanstalkAPIResponse *response))completionHandler;
- (BeanstalkAPIRequest *)deletePublicKeyWithID:(NSInteger)publicKeyID completionHandler:(void (^)(BeanstalkAPIResponse *response))completionHandler;

@end
