//
//  BeanstalkUser.h
//  BeanstalkAPI
//
//  Created by Alexander Rinaß on 12.06.12.
//  Copyright (c) 2012 Fournova GmbH. All rights reserved.
//

#import <FNFoundation/FNFoundation.h>

@interface BeanstalkAPIUser : FNRESTAPIModel
@property (nonatomic, readonly) NSInteger userID;
@property (nonatomic, readonly) NSInteger accountID;
@property (nonatomic, readonly) NSString *login;
@property (nonatomic, readonly) NSString *name;
@property (nonatomic, readonly) NSString *email;
@property (nonatomic, readonly, getter = isOwner) BOOL owner;
@property (nonatomic, readonly, getter = isAdmin) BOOL admin;
@property (nonatomic, readonly) NSString *timezone;
@property (nonatomic, readonly) NSDate *updatedDate;
@property (nonatomic, readonly) NSDate *creationDate;

+ (instancetype)userWithJSONObject:(NSDictionary *)JSONObject;

- (BOOL)isEqualToBeanstalkAPIUser:(BeanstalkAPIUser *)object;

@end
