//
//  BitbucketAuth.h
//  BitbucketAPI
//
//  Created by Patrick Dinger on 07.02.13.
//  Copyright (c) 2013 Fournova GmbH. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "BitbucketAPIAuthenticationMethod.h"

@interface BitbucketAPICredentials : NSObject
@property (nonatomic, readonly) BitbucketAPIAuthenticationMethod authenticationMethod;
@property (nonatomic, nonnull, readonly) NSString *username;
@property (nonatomic, nullable, readonly) NSString *password;
@property (nonatomic, nullable, readonly) NSString *accessToken;

+ (nullable instancetype)new NS_UNAVAILABLE;
+ (nullable instancetype)basicAuthCredentialsWithUsername:(nonnull NSString *)username password:(nonnull NSString *)password;
+ (nullable instancetype)accessTokenCredentialsWithUsername:(nonnull NSString *)username accessToken:(nonnull NSString *)accessToken;

- (nullable instancetype)init NS_UNAVAILABLE;
- (nullable instancetype)initWithAuthenticationMethod:(BitbucketAPIAuthenticationMethod)authenticationMethod username:(nonnull NSString *)username password:(nullable NSString *)password accessToken:(nullable NSString *)accessToken;

@end
