//
//  BitbucketAPIRequestOperation.h
//  BitbucketAPI
//
//  Created by Patrick Dinger on 07.02.13.
//  Copyright (c) 2013 Fournova GmbH. All rights reserved.
//

#import <FNFoundation/FNFoundation.h>
#import "BitbucketAPIModels.h"
#import "BitbucketAPIParsers.h"
#import "BitbucketAPIHelpers.h"
#import "BitbucketAPIConstants.h"

@class BitbucketAPIResponse;

typedef void (^BitbucketAPIRequestCompletionHandler)(BitbucketAPIResponse *response);

@class BitbucketAPICredentials;
@interface BitbucketAPIRequestOperation : FNRESTAPIRequestOperation
@property (nonatomic, readonly) BitbucketAPICredentials *credentials;
@property (nonatomic, copy) BitbucketAPIRequestCompletionHandler completionHandler;
@property (nonatomic) id result;
@property (nonatomic, readonly) BitbucketAPIResponse *APIResponse;

+ (NSDictionary *)defaultOptions;

- (instancetype)initWithCredentials:(BitbucketAPICredentials *)credentials method:(NSString *)method path:(NSString *)path params:(NSDictionary *)params;
- (instancetype)initWithCredentials:(BitbucketAPICredentials *)credentials method:(NSString *)method URL:(NSURL *)URL params:(NSDictionary *)params;

@end
