//
//  FNApplicationEnvironment.h
//  FNAppKit
//
//  Created by Alexander Rinass on 17/05/16.
//  Copyright © 2016 Fournova GmbH. All rights reserved.
//

#import <Foundation/Foundation.h>

@interface FNApplicationEnvironment : NSObject
@property (nonatomic, nonnull, readonly) NSDictionary *dictionaryRepresentation;

+ (nullable instancetype)environmentFromPropertyListFileAtURL:(nonnull NSURL *)propertyListFileURL error:(NSError * _Nullable __autoreleasing * _Nullable)error;
+ (nullable instancetype)environmentFromJSONFileAtURL:(nonnull NSURL *)JSONFileURL error:(NSError * _Nullable __autoreleasing * _Nullable)error;

- (nullable NSString *)valueForEnvironmentVariable:(nonnull NSString *)environmentVariable;
- (void)setValue:(nullable NSString *)value forEnvironmentVariable:(nonnull NSString *)environmentVariable;
- (void)unsetValueForEnvironmentVariable:(nonnull NSString *)environmentVariable;
- (void)setValuesFromDictionary:(nonnull NSDictionary *)environment;

- (BOOL)writeEnvironmentToPropertyListFileAtURL:(nonnull NSURL *)propertyListFileURL error:(NSError * _Nullable __autoreleasing * _Nullable)error;
- (BOOL)writeEnvironmentToJSONFileAtURL:(nonnull NSURL *)JSONFileURL error:(NSError * _Nullable __autoreleasing * _Nullable)error;

@end
