//
//  FNListManager.h
//  FNFoundation
//
//  Created by Heiko Witte on 22.03.16.
//  Copyright © 2016 fournova Software GmbH. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "FNListManagerDelegate.h"
#import "FNListComparator.h"
#import "FNListItem.h"

@class FNListChangeset;
@interface FNListManager : NSObject
@property (nonatomic, weak) id<FNListManagerDelegate> delegate;
@property (nonatomic) id<FNOrderedCollectionComparator> comparator;

- (NSArray<id<FNListItem>> *)updateList:(NSArray<id<FNListItem>> *)oldList withList:(NSArray<id<FNListItem>> *)newList;
- (NSArray<id<FNListItem>> *)updateList:(NSArray<id<FNListItem>> *)oldList withList:(NSArray<id<FNListItem>> *)newList updateHandler:(void (^)(id<FNListItem> oldItem, id<FNListItem> newItem))updateHandler;
@end
